/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook;

import com.sk89q.craftbook.CraftBookPlayer;
import com.sk89q.craftbook.bukkit.BukkitCraftBookPlayer;
import com.sk89q.craftbook.bukkit.paperlib.PaperLib;
import com.sk89q.craftbook.mechanics.variables.VariableCommands;
import com.sk89q.craftbook.mechanics.variables.VariableManager;
import com.sk89q.craftbook.util.ParsingUtil;
import com.sk89q.craftbook.util.RegexUtil;
import java.util.Arrays;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;

public class ChangedSign {
    private Block block;
    private Sign sign;
    private String[] lines;
    private String[] oldLines;

    public ChangedSign(Block block, String[] lines, CraftBookPlayer player) {
        this(block, lines);
        if (player != null) {
            this.checkPlayerVariablePermissions(player);
        }
    }

    public ChangedSign(Block block, String[] lines) {
        Validate.notNull((Object)block);
        this.block = block;
        if (lines == null) {
            this.flushLines();
        } else {
            this.lines = lines;
            this.oldLines = new String[this.lines.length];
            System.arraycopy(this.lines, 0, this.oldLines, 0, this.lines.length);
        }
    }

    public void checkPlayerVariablePermissions(CraftBookPlayer player) {
        if (this.lines != null && VariableManager.instance != null) {
            for (int i = 0; i < 4; ++i) {
                String line = this.lines[i];
                for (String var : ParsingUtil.getPossibleVariables(line)) {
                    String key;
                    if (var.contains("|")) {
                        String[] bits = RegexUtil.PIPE_PATTERN.split(var);
                        key = bits[0];
                    } else {
                        key = "global";
                    }
                    if (VariableCommands.hasVariablePermission((CommandSender)((BukkitCraftBookPlayer)player).getPlayer(), key, var, "use")) continue;
                    this.setLine(i, StringUtils.replace((String)line, (String)('%' + key + '|' + var + '%'), (String)""));
                }
            }
        }
    }

    public Block getBlock() {
        return this.block;
    }

    public Sign getSign() {
        if (this.sign == null) {
            this.sign = (Sign)PaperLib.getBlockState(this.block, false).getState();
        }
        return this.sign;
    }

    public Material getType() {
        return this.block.getType();
    }

    public byte getLightLevel() {
        return this.block.getLightLevel();
    }

    public int getX() {
        return this.block.getX();
    }

    public int getY() {
        return this.block.getY();
    }

    public int getZ() {
        return this.block.getZ();
    }

    public String[] getLines() {
        return this.lines;
    }

    public String getLine(int index) throws IndexOutOfBoundsException {
        return ParsingUtil.parseLine(this.lines[index], null);
    }

    public String getRawLine(int index) throws IndexOutOfBoundsException {
        return this.lines[index];
    }

    public void setLine(int index, String line) throws IndexOutOfBoundsException {
        this.lines[index] = line;
    }

    public void setType(Material type) {
        this.block.setType(type);
    }

    public boolean update(boolean force) {
        if (!this.hasChanged() && !force) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            this.getSign().setLine(i, this.lines[i]);
        }
        System.arraycopy(this.lines, 0, this.oldLines, 0, this.lines.length);
        return this.getSign().update(force, false);
    }

    public void setLines(String[] lines) {
        this.lines = lines;
    }

    public void setOldLines(String[] oldLines) {
        this.oldLines = oldLines;
    }

    public boolean hasChanged() {
        boolean ret = false;
        try {
            for (int i = 0; i < 4; ++i) {
                if (this.oldLines[i].equals(this.lines[i])) continue;
                ret = true;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public void flushLines() {
        this.sign = null;
        this.lines = this.getSign().getLines();
        if (this.oldLines == null) {
            this.oldLines = new String[this.lines.length];
        }
        System.arraycopy(this.lines, 0, this.oldLines, 0, this.lines.length);
    }

    public boolean updateSign(ChangedSign sign) {
        if (!this.equals(sign)) {
            this.flushLines();
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o instanceof ChangedSign) {
            if (((ChangedSign)o).getType() != this.getType()) {
                return false;
            }
            for (int i = 0; i < 4; ++i) {
                if (((ChangedSign)o).getRawLine(i).equals(this.getRawLine(i))) continue;
                return false;
            }
            if (((ChangedSign)o).getX() != this.getX()) {
                return false;
            }
            if (((ChangedSign)o).getY() != this.getY()) {
                return false;
            }
            if (((ChangedSign)o).getZ() != this.getZ()) {
                return false;
            }
            return ((ChangedSign)o).block.getWorld().getUID().equals(this.block.getWorld().getUID());
        }
        return false;
    }

    public int hashCode() {
        return this.getType().hashCode() * 1103515245 + 12345 ^ Arrays.hashCode(this.lines) * 1103515245 + 12345 ^ this.getX() * 1103515245 + 12345 ^ this.getY() * 1103515245 + 12345 ^ this.getZ() * 1103515245 + 12345 ^ this.block.getWorld().getUID().hashCode() * 1103515245 + 12345;
    }

    public String toString() {
        return this.lines[0] + '|' + this.lines[1] + '|' + this.lines[2] + '|' + this.lines[3];
    }

    public boolean hasVariable(String var) {
        if (VariableManager.instance == null) {
            return false;
        }
        var = var.toLowerCase(Locale.ENGLISH);
        return this.lines[0].toLowerCase(Locale.ENGLISH).contains('%' + var + '%') || this.lines[1].toLowerCase(Locale.ENGLISH).contains('%' + var + '%') || this.lines[2].toLowerCase(Locale.ENGLISH).contains('%' + var + '%') || this.lines[3].toLowerCase(Locale.ENGLISH).contains('%' + var + '%');
    }
}

