/*
 * Decompiled with CFR 0.152.
 */
package com.me4502.util;

import com.sk89q.craftbook.CraftBookMechanic;
import com.sk89q.craftbook.bukkit.CraftBookPlugin;
import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.craftbook.util.developer.ExternalUtilityBase;
import com.sk89q.util.yaml.YAMLProcessor;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Bukkit;

public class GenerateWikiConfigLists
extends ExternalUtilityBase {
    static int missingComments = 0;

    public GenerateWikiConfigLists(String[] args) {
        super(args);
    }

    public static void createConfigSectionFile(File folder, YAMLProcessor config, String path) throws IOException {
        String fpath = path;
        if (fpath == null) {
            fpath = "root";
        } else if (fpath.contains(".")) {
            fpath = RegexUtil.PERIOD_PATTERN.split(fpath)[RegexUtil.PERIOD_PATTERN.split(fpath).length - 1];
        }
        File file = new File(folder, fpath + ".txt");
        if (!file.exists()) {
            new File(file.getParent()).mkdirs();
            file.createNewFile();
        } else {
            file.delete();
            file.createNewFile();
        }
        if (config.getKeys(path) == null) {
            return;
        }
        PrintWriter pw = new PrintWriter(file, "UTF-8");
        pw.print("Configuration\n");
        pw.append("=============\n\n");
        int nodeLength = "Node".length();
        int commentLength = "Comment".length();
        int defaultLength = "Default".length();
        for (String key : config.getKeys(path)) {
            String comment;
            String def;
            String node;
            if (config.getProperty(path == null ? key : path + "." + key) == null || config.getProperty(path == null ? key : path + "." + key) instanceof Map) continue;
            String string = node = path == null ? key : path + "." + key;
            if (nodeLength < node.length()) {
                nodeLength = node.length();
            }
            if (defaultLength < (def = String.valueOf(config.getProperty(path == null ? key : path + "." + key))).length()) {
                defaultLength = def.length();
            }
            if ((comment = config.getComment(path == null ? key : path + "." + key)) == null) {
                comment = "";
            }
            if (!comment.trim().isEmpty()) {
                comment = comment.trim().substring(2);
            }
            if (commentLength >= comment.length()) continue;
            commentLength = comment.length();
        }
        String border = GenerateWikiConfigLists.createStringOfLength(nodeLength, '=') + ' ' + GenerateWikiConfigLists.createStringOfLength(commentLength, '=') + ' ' + GenerateWikiConfigLists.createStringOfLength(defaultLength, '=');
        pw.println(border);
        pw.print(GenerateWikiConfigLists.padToLength("Node", nodeLength + 1));
        pw.print(GenerateWikiConfigLists.padToLength("Comment", commentLength + 1));
        pw.println(GenerateWikiConfigLists.padToLength("Default", defaultLength + 1));
        pw.println(border);
        for (String key : config.getKeys(path)) {
            if (config.getProperty(path == null ? key : path + "." + key) != null && !(config.getProperty(path == null ? key : path + "." + key) instanceof Map)) {
                String comment = config.getComment(path == null ? key : path + "." + key);
                if (comment == null) {
                    System.out.println("[WARNING] Key " + path == null ? key : path + "." + key + " is missing a comment!");
                    comment = "";
                    ++missingComments;
                }
                if (!comment.trim().isEmpty()) {
                    comment = comment.trim().substring(2);
                }
                pw.print(GenerateWikiConfigLists.padToLength(path == null ? key : path + "." + key, nodeLength + 1));
                pw.print(GenerateWikiConfigLists.padToLength(comment, commentLength + 1));
                pw.println(GenerateWikiConfigLists.padToLength(String.valueOf(config.getProperty(path == null ? key : path + "." + key)), defaultLength + 1));
                continue;
            }
            GenerateWikiConfigLists.createConfigSectionFile(new File(folder, key + "/"), config, path == null ? key : path + "." + key);
        }
        pw.println(border);
        pw.close();
    }

    public static String createStringOfLength(int length, char character) {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            ret.append(character);
        }
        return ret.toString();
    }

    public static String padToLength(String input, int length) {
        StringBuilder builder = new StringBuilder(input);
        while (builder.length() < length) {
            builder.append(' ');
        }
        return builder.toString();
    }

    @Override
    public void generate(String[] args) {
        File configFolder = new File(this.getGenerationFolder(), "configs/");
        configFolder.mkdir();
        missingComments = 0;
        try {
            GenerateWikiConfigLists.createConfigSectionFile(configFolder, CraftBookPlugin.inst().getConfiguration().config, null);
            CraftBookPlugin.availableMechanics.forEach((mech, aClass) -> {
                try {
                    try {
                        if (aClass != null) {
                            CraftBookMechanic me = (CraftBookMechanic)aClass.newInstance();
                            me.loadConfiguration(CraftBookPlugin.inst().getMechanismsConfig(), "mechanics." + mech + ".");
                        }
                    }
                    catch (Throwable t) {
                        Bukkit.getLogger().log(Level.WARNING, "Failed to load mechanic: " + mech, t);
                    }
                    GenerateWikiConfigLists.createConfigSectionFile(configFolder, CraftBookPlugin.inst().getMechanismsConfig(), "mechanics." + mech);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(missingComments + " Comments Are Missing");
    }
}

