// $Id$
/*
 * Copyright (C) 2010, 2011 sk89q <http://www.sk89q.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

package com.sk89q.commandbook.component.locations;

import com.sk89q.commandbook.CommandBook;
import org.bukkit.Location;
import org.bukkit.entity.Player;

import java.util.UUID;

public class NamedLocation {

    private String name;
    private UUID creatorID;
    private String creatorName;
    private String worldName;
    private Location loc;

    public NamedLocation(String name, Location loc) {
        this.name = name;
        this.loc = loc;
    }
    
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getWorldName() {
        return worldName;
    }

    public void setWorldName(String worldName) {
        this.worldName = worldName;
    }

    public UUID getCreatorID() {
        return creatorID;
    }

    public void setCreatorID(UUID creatorID) {
        this.creatorID = creatorID;
    }

    public String getCreatorName() {
        if (creatorName == null || creatorName.isEmpty()) {
            return CommandBook.server().getOfflinePlayer(creatorID).getName();
        }
        return creatorName;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public Location getLocation() {
        return loc;
    }

    public void setLocation(Location loc) {
        this.loc = loc;
    }
    
    public void teleport(Player player) {
        loc.getChunk().load(true);
        player.teleport(loc);
    }
}
