/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook.util.entity;

import com.sk89q.commandbook.util.entity.ProjectileUtil;
import com.sk89q.minecraft.util.commands.CommandException;
import java.util.Set;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class EntityUtil {
    public static <T extends Projectile> T sendProjectileFromEntity(LivingEntity entity, Vector dir, float speed, Class<T> clazz) {
        T projectile = ProjectileUtil.sendProjectileFromLocation(entity.getEyeLocation(), dir, speed, clazz);
        projectile.setShooter((ProjectileSource)entity);
        return projectile;
    }

    public static <T extends Projectile> Set<T> sendProjectilesFromEntity(LivingEntity entity, int amt, float speed, Class<T> clazz) {
        Set<Projectile> projectiles = ProjectileUtil.sendProjectilesFromLocation(entity.getEyeLocation(), amt, speed, clazz);
        for (Projectile projectile : projectiles) {
            projectile.setShooter((ProjectileSource)entity);
        }
        return projectiles;
    }

    public static String getCardinalDirection(Entity entity) {
        double rot = (entity.getLocation().getYaw() - 90.0f) % 360.0f;
        if (rot < 0.0) {
            rot += 360.0;
        }
        return EntityUtil.getDirection(rot);
    }

    private static String getDirection(double rot) {
        if (0.0 <= rot && rot < 22.5) {
            return "West";
        }
        if (22.5 <= rot && rot < 67.5) {
            return "Northwest";
        }
        if (67.5 <= rot && rot < 112.5) {
            return "North";
        }
        if (112.5 <= rot && rot < 157.5) {
            return "Northeast";
        }
        if (157.5 <= rot && rot < 202.5) {
            return "East";
        }
        if (202.5 <= rot && rot < 247.5) {
            return "Southeast";
        }
        if (247.5 <= rot && rot < 292.5) {
            return "South";
        }
        if (292.5 <= rot && rot < 337.5) {
            return "Southwest";
        }
        if (337.5 <= rot && rot < 360.0) {
            return "West";
        }
        return null;
    }

    public static EntityType matchCreatureType(CommandSender sender, String filter, boolean requireSpawnable) throws CommandException {
        EntityType partialMatch = null;
        for (EntityType type : EntityType.values()) {
            Class clazz = type.getEntityClass();
            if (clazz == null || !LivingEntity.class.isAssignableFrom(clazz) || requireSpawnable && !type.isSpawnable()) continue;
            if (type.name().replace("_", "").equalsIgnoreCase(filter.replace("_", ""))) {
                return type;
            }
            if (type.getName() != null) {
                if (type.getName().equalsIgnoreCase(filter)) {
                    return type;
                }
                if (type.getName().toLowerCase().startsWith(filter.toLowerCase())) {
                    partialMatch = type;
                }
            }
            if (!type.name().replace("_", "").equalsIgnoreCase(filter.replace("_", "")) && (type.getName() == null || !type.getName().equalsIgnoreCase(filter) || !type.isSpawnable() && requireSpawnable)) continue;
            return type;
        }
        if (partialMatch != null) {
            return partialMatch;
        }
        throw new CommandException("Unknown mob specified! You can choose from the list of: " + EntityUtil.getCreatureNameList(requireSpawnable));
    }

    public static String getCreatureNameList(boolean requireSpawnable) {
        StringBuilder str = new StringBuilder();
        for (EntityType type : EntityType.values()) {
            Class entityClass = type.getEntityClass();
            if (entityClass == null || !LivingEntity.class.isAssignableFrom(entityClass) || requireSpawnable && !type.isSpawnable()) continue;
            if (str.length() > 0) {
                str.append(", ");
            }
            str.append(type.getName());
        }
        return str.toString();
    }
}

