/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook.util;

import com.google.common.collect.Lists;
import com.sk89q.commandbook.CommandBook;
import com.sk89q.commandbook.locations.HomesComponent;
import com.sk89q.commandbook.locations.LocationsComponent;
import com.sk89q.commandbook.locations.NamedLocation;
import com.sk89q.commandbook.locations.RootLocationManager;
import com.sk89q.commandbook.locations.WarpsComponent;
import com.sk89q.commandbook.util.LocationUtil;
import com.sk89q.commandbook.util.entity.player.PlayerUtil;
import com.sk89q.commandbook.util.entity.player.comparison.PlayerComparisonUtil;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class InputUtil {

    public static class LocationParser {
        public static World matchWorld(CommandSender sender, String filter) throws CommandException {
            List worlds = CommandBook.server().getWorlds();
            if (filter.charAt(0) == '#') {
                if (filter.equalsIgnoreCase("#main")) {
                    return (World)worlds.get(0);
                }
                if (filter.equalsIgnoreCase("#normal")) {
                    for (World world : worlds) {
                        if (world.getEnvironment() != World.Environment.NORMAL) continue;
                        return world;
                    }
                    throw new CommandException("No normal world found.");
                }
                if (filter.equalsIgnoreCase("#nether")) {
                    for (World world : worlds) {
                        if (world.getEnvironment() != World.Environment.NETHER) continue;
                        return world;
                    }
                    throw new CommandException("No nether world found.");
                }
                if (filter.equalsIgnoreCase("#theend") || filter.equalsIgnoreCase("#end")) {
                    for (World world : worlds) {
                        if (world.getEnvironment() != World.Environment.THE_END) continue;
                        return world;
                    }
                    throw new CommandException("No end world found.");
                }
                if (filter.matches("^#player$")) {
                    String[] parts = filter.split(":", 2);
                    if (parts.length == 1) {
                        throw new CommandException("Argument expected for #player.");
                    }
                    return PlayerParser.matchPlayers(sender, parts[1]).iterator().next().getWorld();
                }
                throw new CommandException("Invalid identifier '" + filter + "'.");
            }
            for (World world : worlds) {
                if (!world.getName().equals(filter)) continue;
                return world;
            }
            throw new CommandException("No world by that exact name found.");
        }

        public static Location matchLocation(CommandSender source, String filter) throws CommandException {
            return LocationParser.matchLocations(source, filter, true).get(0);
        }

        public static List<Location> matchLocations(CommandSender source, String filter) throws CommandException {
            return LocationParser.matchLocations(source, filter, false);
        }

        private static List<Location> matchLocations(CommandSender source, String filter, boolean strictMatching) throws CommandException {
            if (filter.matches("^[\\-0-9\\.]+,[\\-0-9\\.]+,[\\-0-9\\.]+(?:.+)?$")) {
                double z;
                double y;
                double x;
                CommandBook.inst().checkPermission(source, "commandbook.locations.coords");
                String[] args = filter.split(":");
                String[] parts = args[0].split(",");
                try {
                    x = Double.parseDouble(parts[0]);
                    y = Double.parseDouble(parts[1]);
                    z = Double.parseDouble(parts[2]);
                }
                catch (NumberFormatException e) {
                    throw new CommandException("Coordinates expected numbers!");
                }
                if (args.length > 1) {
                    return Lists.newArrayList((Object[])new Location[]{new Location(LocationParser.matchWorld(source, args[1]), x, y, z)});
                }
                Player player = PlayerUtil.checkPlayer(source);
                return Lists.newArrayList((Object[])new Location[]{new Location(player.getWorld(), x, y, z)});
            }
            if (filter.charAt(0) == '#') {
                String[] args = filter.split(":");
                if (args[0].equalsIgnoreCase("#spawn")) {
                    CommandBook.inst().checkPermission(source, "commandbook.spawn");
                    if (args.length > 1) {
                        return Lists.newArrayList((Object[])new Location[]{LocationParser.matchWorld(source, args[1]).getSpawnLocation()});
                    }
                    Player sourcePlayer = PlayerUtil.checkPlayer(source);
                    return Lists.newArrayList((Object[])new Location[]{sourcePlayer.getLocation().getWorld().getSpawnLocation()});
                }
                if (args[0].equalsIgnoreCase("#target")) {
                    CommandBook.inst().checkPermission(source, "commandbook.locations.target");
                    Player player = PlayerUtil.checkPlayer(source);
                    Location playerLoc = player.getLocation();
                    Block targetBlock = player.getTargetBlock((Set)null, 100);
                    if (targetBlock == null) {
                        throw new CommandException("Failed to find a block in your target!");
                    }
                    Location loc = targetBlock.getLocation();
                    playerLoc.setX(loc.getX());
                    playerLoc.setY(loc.getY());
                    playerLoc.setZ(loc.getZ());
                    return Lists.newArrayList((Object[])new Location[]{LocationUtil.findFreePosition(playerLoc)});
                }
                if (args[0].equalsIgnoreCase("#home") || args[0].equalsIgnoreCase("#warp")) {
                    LocationsComponent component;
                    String type = args[0].substring(1);
                    CommandBook.inst().checkPermission(source, "commandbook.locations." + type);
                    LocationsComponent locationsComponent = component = type.equalsIgnoreCase("warp") ? (LocationsComponent)((Object)CommandBook.inst().getComponentManager().getComponent(WarpsComponent.class)) : (LocationsComponent)((Object)CommandBook.inst().getComponentManager().getComponent(HomesComponent.class));
                    if (component == null) {
                        throw new CommandException("This type of location is not enabled!");
                    }
                    RootLocationManager<NamedLocation> manager = component.getManager();
                    if (args.length == 1) {
                        if (type.equalsIgnoreCase("warp")) {
                            throw new CommandException("Please specify a warp name.");
                        }
                        Player ply = PlayerUtil.checkPlayer(source);
                        NamedLocation loc = manager.get(ply.getWorld(), ply.getName());
                        if (loc == null) {
                            throw new CommandException("You have not set your home yet.");
                        }
                        return Lists.newArrayList((Object[])new Location[]{loc.getLocation()});
                    }
                    if (args.length == 2) {
                        Player player;
                        NamedLocation loc;
                        if (source instanceof Player && (loc = manager.get((player = (Player)source).getWorld(), args[1])) != null && !loc.getCreatorName().equalsIgnoreCase(player.getName())) {
                            CommandBook.inst().checkPermission(source, "commandbook.locations." + type + ".other");
                        }
                        return Lists.newArrayList((Object[])new Location[]{LocationUtil.getManagedLocation(manager, PlayerUtil.checkPlayer(source).getWorld(), args[1])});
                    }
                    if (args.length == 3) {
                        if (source instanceof Player) {
                            Player player = (Player)source;
                            NamedLocation loc = manager.get(LocationParser.matchWorld(source, args[2]), args[1]);
                            if (loc != null && !loc.getCreatorName().equalsIgnoreCase(player.getName())) {
                                CommandBook.inst().checkPermission(source, "commandbook.locations." + type + ".other");
                            }
                        }
                        return Lists.newArrayList((Object[])new Location[]{LocationUtil.getManagedLocation(manager, LocationParser.matchWorld(source, args[2]), args[1])});
                    }
                } else {
                    if (args[0].equalsIgnoreCase("#me")) {
                        return Lists.newArrayList((Object[])new Location[]{PlayerUtil.checkPlayer(source).getLocation()});
                    }
                    throw new CommandException("Invalid group '" + filter + "'.");
                }
            }
            List<Player> players = strictMatching ? PlayerParser.matchPlayerNames(source, filter) : PlayerParser.matchPlayers(source, filter);
            PlayerParser.checkPlayerMatch(players);
            ArrayList<Location> locations = new ArrayList<Location>();
            for (Player player : players) {
                locations.add(player.getLocation());
            }
            return locations;
        }
    }

    public static class PlayerParser {
        public static List<Player> matchPlayerNames(CommandSender source, String filter) {
            Collection players = CommandBook.server().getOnlinePlayers();
            boolean useDisplayNames = CommandBook.inst().lookupWithDisplayNames;
            if ((filter = filter.toLowerCase()).length() >= 2) {
                boolean endWildCard;
                boolean exactMatch = filter.charAt(0) == '@';
                boolean startWildCard = filter.charAt(0) == '*';
                boolean bl = endWildCard = filter.charAt(filter.length() - 1) == '*';
                if (exactMatch) {
                    try {
                        return Lists.newArrayList((Object[])new Player[]{PlayerParser.matchPlayerExactly(source, filter.substring(1))});
                    }
                    catch (CommandException e) {
                        return new ArrayList<Player>();
                    }
                }
                if (startWildCard || endWildCard) {
                    filter = startWildCard && endWildCard ? filter.substring(1, filter.length() - 1) : (startWildCard ? filter.substring(1) : filter.substring(0, filter.length() - 1));
                    ArrayList<Player> list = new ArrayList<Player>();
                    for (Player player : players) {
                        String targetName = player.getName().toLowerCase();
                        String targetDisplayName = ChatColor.stripColor((String)player.getDisplayName().toLowerCase());
                        if (startWildCard && endWildCard) {
                            if (!targetName.contains(filter) && (!useDisplayNames || !targetDisplayName.contains(filter))) continue;
                            list.add(player);
                            continue;
                        }
                        if (startWildCard) {
                            if (!targetName.endsWith(filter) && (!useDisplayNames || !targetDisplayName.endsWith(filter))) continue;
                            list.add(player);
                            continue;
                        }
                        if (!targetName.startsWith(filter) && (!useDisplayNames || !targetDisplayName.startsWith(filter))) continue;
                        list.add(player);
                    }
                    return PlayerComparisonUtil.prioritySort(source, list);
                }
            }
            ArrayList<Player> list = new ArrayList<Player>();
            for (Player player : players) {
                if (!player.getName().toLowerCase().startsWith(filter) && (!useDisplayNames || !ChatColor.stripColor((String)player.getDisplayName().toLowerCase()).startsWith(filter))) continue;
                list.add(player);
            }
            return PlayerComparisonUtil.prioritySort(source, list);
        }

        public static List<Player> matchPlayers(CommandSender source, String filter) throws CommandException {
            if (CommandBook.server().getOnlinePlayers().isEmpty()) {
                throw new CommandException("No players matched query.");
            }
            if (filter.equals("*")) {
                CommandBook.inst().checkPermission(source, "commandbook.targets.everyone");
                return PlayerParser.checkPlayerMatch(Lists.newArrayList((Iterable)CommandBook.server().getOnlinePlayers()));
            }
            if (filter.charAt(0) == '#') {
                if (filter.equalsIgnoreCase("#world")) {
                    World sourceWorld = PlayerUtil.checkPlayer(source).getWorld();
                    CommandBook.inst().checkPermission(source, "commandbook.targets.world." + sourceWorld.getName());
                    return PlayerParser.checkPlayerMatch(sourceWorld.getPlayers());
                }
                if (filter.startsWith("#near")) {
                    CommandBook.inst().checkPermission(source, "commandbook.targets.near");
                    ArrayList<Player> players = new ArrayList<Player>();
                    Player sourcePlayer = PlayerUtil.checkPlayer(source);
                    World sourceWorld = sourcePlayer.getWorld();
                    Location sourceLocation = sourcePlayer.getLocation();
                    double targetDistance = 30.0;
                    String[] split = filter.split(":");
                    if (split.length == 2) {
                        try {
                            targetDistance = Double.parseDouble(split[1]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    targetDistance = Math.pow(targetDistance, 2.0);
                    Location k = sourceLocation.clone();
                    for (Player player : CommandBook.server().getOnlinePlayers()) {
                        if (!player.getWorld().equals(sourceWorld) || !(player.getLocation(k).distanceSquared(sourceLocation) < targetDistance)) continue;
                        players.add(player);
                    }
                    return PlayerParser.checkPlayerMatch(players);
                }
                throw new CommandException("Invalid group '" + filter + "'.");
            }
            return PlayerParser.checkPlayerMatch(PlayerParser.matchPlayerNames(source, filter));
        }

        public static Player matchPlayerExactly(CommandSender sender, String filter) throws CommandException {
            Collection players = CommandBook.server().getOnlinePlayers();
            for (Player player : players) {
                if (!player.getName().equalsIgnoreCase(filter) && (!CommandBook.inst().lookupWithDisplayNames || !player.getDisplayName().equalsIgnoreCase(filter))) continue;
                return player;
            }
            throw new CommandException("No player found!");
        }

        public static Player matchSinglePlayer(CommandSender sender, String filter) throws CommandException {
            return PlayerParser.checkSinglePlayerMatch(PlayerParser.matchPlayers(sender, filter));
        }

        public static CommandSender matchPlayerOrConsole(CommandSender sender, String filter) throws CommandException {
            if (filter.equalsIgnoreCase("#console") || filter.equalsIgnoreCase("*console*") || filter.equalsIgnoreCase("!")) {
                return CommandBook.server().getConsoleSender();
            }
            return PlayerParser.matchSinglePlayer(sender, filter);
        }

        public static Iterable<Player> detectTargets(CommandSender sender, CommandContext args, String perm) throws CommandException {
            ArrayList targets = args.argsLength() == 0 ? Lists.newArrayList((Object[])new Player[]{PlayerUtil.checkPlayer(sender)}) : PlayerParser.matchPlayers(sender, args.getString(0));
            PlayerParser.checkPlayerMatch(targets);
            for (Player player : targets) {
                if (player.equals(sender)) {
                    CommandBook.inst().checkPermission(sender, perm);
                    continue;
                }
                CommandBook.inst().checkPermission(sender, perm + ".other");
                break;
            }
            return targets;
        }

        @Deprecated
        public static List<Player> checkPlayerMatch(List<Player> players) throws CommandException {
            if (players.isEmpty()) {
                throw new CommandException("No players matched query.");
            }
            return players;
        }

        public static <T extends Collection<? extends Player>> T checkPlayerMatch(T players) throws CommandException {
            if (players.isEmpty()) {
                throw new CommandException("No players matched query.");
            }
            return players;
        }

        public static Player checkSinglePlayerMatch(List<Player> players) throws CommandException {
            if (players.size() > 1) {
                throw new CommandException("More than one player found! Use @<name> for exact matching.");
            }
            return players.get(0);
        }
    }

    public static class TimeParser {
        protected static final Pattern TWELVE_HOUR_TIME = Pattern.compile("^([0-9]+(?::[0-9]+)?)([apmAPM\\.]+)$");

        public static long matchDate(String filter) throws CommandException {
            if (filter == null) {
                return 0L;
            }
            if (filter.equalsIgnoreCase("now")) {
                return System.currentTimeMillis();
            }
            String[] groupings = filter.split("-");
            if (groupings.length == 0) {
                throw new CommandException("Invalid date specified");
            }
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTimeInMillis(0L);
            for (String str : groupings) {
                int type;
                switch (str.charAt(str.length() - 1)) {
                    case 'm': {
                        type = 12;
                        break;
                    }
                    case 'h': {
                        type = 10;
                        break;
                    }
                    case 'd': {
                        type = 5;
                        break;
                    }
                    case 'w': {
                        type = 3;
                        break;
                    }
                    case 'y': {
                        type = 1;
                        break;
                    }
                    default: {
                        throw new CommandException("Unknown date value specified");
                    }
                }
                ((Calendar)cal).add(type, Integer.valueOf(str.substring(0, str.length() - 1)));
            }
            return cal.getTimeInMillis();
        }

        public static long matchFutureDate(String filter) throws CommandException {
            return TimeParser.matchDate(filter) + System.currentTimeMillis();
        }

        public static int matchMCWorldTime(String timeStr) throws CommandException {
            try {
                int time = Integer.parseInt(timeStr);
                if (time <= 24) {
                    return (time - 8) % 24 * 1000;
                }
                return time;
            }
            catch (NumberFormatException time) {
                if (timeStr.matches("^*[0-9]+$")) {
                    return Integer.parseInt(timeStr.substring(1));
                }
                if (timeStr.matches("^[0-9]+:[0-9]+$")) {
                    String[] parts = timeStr.split(":");
                    int hours = Integer.parseInt(parts[0]);
                    int mins = Integer.parseInt(parts[1]);
                    return (int)((long)((hours - 8) % 24 * 1000) + Math.round((double)(mins % 60) / 60.0 * 1000.0));
                }
                Matcher matcher = TWELVE_HOUR_TIME.matcher(timeStr);
                if (matcher.matches()) {
                    int shift;
                    String time2 = matcher.group(1);
                    String period = matcher.group(2);
                    if (period.equalsIgnoreCase("am") || period.equalsIgnoreCase("a.m.")) {
                        shift = 0;
                    } else if (period.equalsIgnoreCase("pm") || period.equalsIgnoreCase("p.m.")) {
                        shift = 12;
                    } else {
                        throw new CommandException("'am' or 'pm' expected, got '" + period + "'.");
                    }
                    String[] parts = time2.split(":");
                    int hours = Integer.parseInt(parts[0]);
                    int mins = parts.length >= 2 ? Integer.parseInt(parts[1]) : 0;
                    return (int)((double)((hours % 12 + shift - 8) % 24 * 1000) + (double)(mins % 60) / 60.0 * 1000.0);
                }
                if (timeStr.equalsIgnoreCase("dawn")) {
                    return 22000;
                }
                if (timeStr.equalsIgnoreCase("sunrise")) {
                    return 23000;
                }
                if (timeStr.equalsIgnoreCase("morning")) {
                    return 24000;
                }
                if (timeStr.equalsIgnoreCase("day")) {
                    return 24000;
                }
                if (timeStr.equalsIgnoreCase("midday") || timeStr.equalsIgnoreCase("noon")) {
                    return 28000;
                }
                if (timeStr.equalsIgnoreCase("afternoon")) {
                    return 30000;
                }
                if (timeStr.equalsIgnoreCase("evening")) {
                    return 32000;
                }
                if (timeStr.equalsIgnoreCase("sunset")) {
                    return 37000;
                }
                if (timeStr.equalsIgnoreCase("dusk")) {
                    return 37500;
                }
                if (timeStr.equalsIgnoreCase("night")) {
                    return 38000;
                }
                if (timeStr.equalsIgnoreCase("midnight")) {
                    return 16000;
                }
                throw new CommandException("Time input format unknown.");
            }
        }
    }
}

