/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook.util;

import com.sk89q.commandbook.CommandBook;
import com.sk89q.commandbook.util.ServerUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Calendar;
import java.util.Collection;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class ChatUtil {
    public static void sendMessage(CommandSender sender, String message) {
        for (String line : message.split("\n")) {
            sender.sendMessage(line.replaceAll("[\r\n]", ""));
        }
    }

    public static String toName(CommandSender sender) {
        return ChatColor.stripColor((String)ChatUtil.toColoredName(sender, null));
    }

    public static String toColoredName(CommandSender sender, ChatColor endColor) {
        if (sender instanceof Player) {
            String name;
            String string = name = CommandBook.inst().useDisplayNames ? ((Player)sender).getDisplayName() : sender.getName();
            if (endColor != null && name.contains("\u00a7")) {
                name = name + endColor;
            }
            return name;
        }
        if (sender instanceof ConsoleCommandSender) {
            return "*Console*";
        }
        return sender.getName();
    }

    @Deprecated
    public static String toUniqueName(CommandSender sender) {
        if (sender instanceof Player) {
            return sender.getName();
        }
        return "*Console*";
    }

    public static String toFriendlyString(Location location) {
        return location.getBlockX() + "," + location.getBlockY() + "," + location.getBlockZ() + "@" + location.getWorld().getName();
    }

    public static String replaceMacros(CommandSender sender, String message) {
        Collection online = CommandBook.server().getOnlinePlayers();
        message = message.replace("%name%", ChatUtil.toName(sender));
        message = message.replace("%cname%", ChatUtil.toColoredName(sender, null));
        message = message.replace("%id%", ChatUtil.toUniqueName(sender));
        if ((message = message.replace("%online%", String.valueOf(online.size()))).contains("%players%")) {
            message = message.replace("%players%", ServerUtil.getOnlineList(online, null));
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            World world = player.getWorld();
            message = message.replace("%time%", ChatUtil.getTimeString(world.getTime()));
            message = message.replace("%world%", world.getName());
        }
        Pattern cmdPattern = Pattern.compile("%cmd:([^%]+)%");
        Matcher matcher = cmdPattern.matcher(message);
        try {
            StringBuffer buff = new StringBuffer();
            while (matcher.find()) {
                String s;
                Process p = new ProcessBuilder(matcher.group(1).split(" ")).start();
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                StringBuilder build = new StringBuilder();
                while ((s = stdInput.readLine()) != null) {
                    build.append(s).append(" ");
                }
                stdInput.close();
                build.delete(build.length() - 1, build.length());
                matcher.appendReplacement(buff, build.toString());
                p.destroy();
            }
            matcher.appendTail(buff);
            message = buff.toString();
        }
        catch (IOException e) {
            sender.sendMessage(ChatColor.RED + "Error replacing macros: " + e.getMessage());
        }
        return message;
    }

    public static String replaceColorMacros(String str) {
        str = str.replace("`r", ChatColor.RED.toString());
        str = str.replace("`R", ChatColor.DARK_RED.toString());
        str = str.replace("`y", ChatColor.YELLOW.toString());
        str = str.replace("`Y", ChatColor.GOLD.toString());
        str = str.replace("`g", ChatColor.GREEN.toString());
        str = str.replace("`G", ChatColor.DARK_GREEN.toString());
        str = str.replace("`c", ChatColor.AQUA.toString());
        str = str.replace("`C", ChatColor.DARK_AQUA.toString());
        str = str.replace("`b", ChatColor.BLUE.toString());
        str = str.replace("`B", ChatColor.DARK_BLUE.toString());
        str = str.replace("`p", ChatColor.LIGHT_PURPLE.toString());
        str = str.replace("`P", ChatColor.DARK_PURPLE.toString());
        str = str.replace("`0", ChatColor.BLACK.toString());
        str = str.replace("`1", ChatColor.DARK_GRAY.toString());
        str = str.replace("`2", ChatColor.GRAY.toString());
        str = str.replace("`w", ChatColor.WHITE.toString());
        str = str.replace("`k", ChatColor.MAGIC.toString());
        str = str.replace("`l", ChatColor.BOLD.toString());
        str = str.replace("`m", ChatColor.STRIKETHROUGH.toString());
        str = str.replace("`n", ChatColor.UNDERLINE.toString());
        str = str.replace("`o", ChatColor.ITALIC.toString());
        str = str.replace("`x", ChatColor.RESET.toString());
        return str;
    }

    public static String getTimeString(long time) {
        int hours = (int)((time / 1000L + 8L) % 24L);
        int minutes = (int)(60L * (time % 1000L) / 1000L);
        return String.format("%02d:%02d (%d:%02d %s)", hours, minutes, hours % 12 == 0 ? 12 : hours % 12, minutes, hours < 12 ? "am" : "pm");
    }

    public static String getFriendlyTime(long time) {
        StringBuilder builder = new StringBuilder();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        builder.append(calendar.getDisplayName(2, 2, Locale.US));
        builder.append(" ");
        builder.append(calendar.get(5));
        builder.append(" ");
        builder.append(calendar.get(1));
        builder.append(" at ");
        builder.append(calendar.get(10));
        builder.append(":");
        builder.append(String.format("%02d", calendar.get(12)));
        builder.append(calendar.get(9) == 0 ? "AM" : "PM");
        return builder.toString();
    }
}

