/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook.kits;

import com.sk89q.commandbook.CommandBook;
import com.sk89q.commandbook.kits.Kit;
import com.sk89q.commandbook.kits.KitManager;
import com.sk89q.commandbook.util.item.ItemUtil;
import com.sk89q.worldedit.blocks.BaseItem;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FlatFileKitsManager
implements KitManager {
    private static final Pattern kitPattern = Pattern.compile("^\\[([^\\]=]+)(?:= *([0-9]+) *)?\\]$");
    private final File file;
    private Map<String, Kit> kits = new HashMap<String, Kit>();

    public FlatFileKitsManager(File file) {
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void load() {
        FileInputStream input = null;
        HashMap<String, Kit> kits = new HashMap<String, Kit>();
        try {
            String line;
            input = new FileInputStream(this.file);
            InputStreamReader streamReader = new InputStreamReader((InputStream)input, "utf-8");
            BufferedReader reader = new BufferedReader(streamReader);
            Kit kit = null;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.charAt(0) == '#' || line.charAt(0) == ';') continue;
                Matcher m = kitPattern.matcher(line);
                if (m.matches()) {
                    String id = m.group(1).replace(" ", "").trim().toLowerCase();
                    kit = new Kit();
                    kits.put(id, kit);
                    String coolDownTime = m.group(2);
                    if (coolDownTime == null) continue;
                    try {
                        kit.setCoolDown((long)(Double.parseDouble(coolDownTime) * 1000.0));
                    }
                    catch (NumberFormatException e) {
                        CommandBook.logger().warning("Invalid cool down for " + line);
                    }
                    continue;
                }
                if (kit == null) {
                    CommandBook.logger().warning("Missing \"[kitname]\" section for " + line);
                    continue;
                }
                String[] parts = line.split("-");
                BaseItem item = ItemUtil.getItem(parts[0].replace(" ", ""));
                if (item == null) {
                    CommandBook.logger().warning(" Unknown kit item '" + parts[0].replaceAll(" ", "") + "'");
                    continue;
                }
                int amount = 1;
                if (parts.length >= 2) {
                    try {
                        amount = Integer.parseInt(parts[1]);
                    }
                    catch (NumberFormatException e) {
                        CommandBook.logger().warning("Invalid amount: '" + parts[1] + "'");
                    }
                }
                kit.addItem(BukkitAdapter.adapt((BaseItemStack)new BaseItemStack(item.getType(), item.getNbtData(), amount)));
            }
            CommandBook.logger().info(kits.size() + " kit(s) loaded.");
        }
        catch (FileNotFoundException | UnsupportedEncodingException streamReader) {
        }
        catch (IOException e) {
            CommandBook.logger().warning("Failed to load kits.txt: " + e.getMessage());
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.kits = kits;
    }

    @Override
    public synchronized Kit getKit(String id) {
        return this.kits.get(id.toLowerCase());
    }

    @Override
    public synchronized Map<String, Kit> getKits() {
        return this.kits;
    }

    @Override
    public synchronized void flush() {
        for (Kit kit : this.kits.values()) {
            kit.flush();
        }
    }
}

