/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook.jinglenote;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.enginehub.jinglenote.JingleNotePlayer;
import org.enginehub.jinglenote.bukkit.BukkitJingleNotePlayer;
import org.enginehub.jinglenote.sequencer.JingleSequencer;

public class JingleNoteManager {
    protected final Map<UUID, JingleNotePlayer> instances = new HashMap<UUID, JingleNotePlayer>();

    public void play(Player player, JingleSequencer sequencer) {
        UUID playerID = player.getUniqueId();
        if (this.instances.containsKey(playerID)) {
            JingleNotePlayer existing = this.instances.get(playerID);
            existing.stop();
            this.instances.remove(playerID);
        }
        BukkitJingleNotePlayer notePlayer = new BukkitJingleNotePlayer(player, sequencer);
        Thread thread = new Thread(() -> ((JingleNotePlayer)notePlayer).play());
        thread.setDaemon(true);
        thread.setPriority(10);
        thread.setName("JingleNotePlayer for " + playerID);
        thread.start();
        this.instances.put(playerID, (JingleNotePlayer)notePlayer);
    }

    public boolean stop(UUID playerID) {
        if (this.instances.containsKey(playerID)) {
            JingleNotePlayer existing = this.instances.get(playerID);
            existing.stop();
            this.instances.remove(playerID);
            return true;
        }
        return false;
    }

    public boolean stop(Player player) {
        return this.stop(player.getUniqueId());
    }

    public void stopAll() {
        for (JingleNotePlayer notePlayer : this.instances.values()) {
            notePlayer.stop();
        }
        this.instances.clear();
    }
}

