/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook.bans;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import com.sk89q.commandbook.CommandBook;
import com.sk89q.commandbook.bans.Ban;
import com.sk89q.commandbook.bans.BanDatabase;
import com.sk89q.commandbook.util.ChatUtil;
import com.sk89q.commandbook.util.ServerUtil;
import com.sk89q.commandbook.util.entity.player.UUIDUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.commons.lang.Validate;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CSVBanDatabase
implements BanDatabase {
    protected final Logger auditLogger = Logger.getLogger("Minecraft.CommandBook.Bans");
    protected final File storageFile;
    protected Map<UUID, Ban> UUIDBan = new HashMap<UUID, Ban>();
    @Deprecated
    protected Map<String, Ban> nameBan = null;
    protected Map<String, Ban> ipBan = new HashMap<String, Ban>();
    protected final Set<Ban> bans = new HashSet<Ban>();
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");

    public CSVBanDatabase(File banStorageDir) {
        this.storageFile = new File(banStorageDir, "bans.csv");
        try {
            FileHandler handler = new FileHandler(new File(banStorageDir, "bans.%g.%u.log").getAbsolutePath().replace("\\", "/"), true);
            handler.setFormatter(new Formatter(){

                @Override
                public String format(LogRecord record) {
                    return "[" + dateFormat.format(new Date()) + "] " + record.getMessage() + "\r\n";
                }
            });
            this.auditLogger.addHandler(handler);
        }
        catch (SecurityException e) {
            CommandBook.logger().warning("Failed to setup audit log for the CSV ban database: " + e.getMessage());
        }
        catch (IOException e) {
            CommandBook.logger().warning("Failed to setup audit log for the CSV ban database: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean load() {
        FileInputStream input = null;
        boolean successful = true;
        boolean needsSaved = false;
        try {
            String[] line;
            input = new FileInputStream(this.storageFile);
            InputStreamReader streamReader = new InputStreamReader((InputStream)input, "utf-8");
            CSVReader reader = new CSVReader((Reader)new BufferedReader(streamReader));
            while ((line = reader.readNext()) != null) {
                int lineLen = line.length;
                if (lineLen < 5) {
                    CommandBook.logger().warning("A ban entry with < 5 fields was found!");
                    continue;
                }
                try {
                    String rawLine;
                    int i = 0;
                    UUID ID = null;
                    if (lineLen > 5 && !(rawLine = line[i++]).isEmpty() && !rawLine.equals("null")) {
                        ID = UUID.fromString(rawLine);
                    }
                    String name = line[i++].toLowerCase();
                    String address = line[i++];
                    String reason = line[i++];
                    long startDate = Long.parseLong(line[i++]);
                    long endDate = Long.parseLong(line[i++]);
                    if ("".equals(name) || "null".equals(name)) {
                        name = null;
                    }
                    if ("".equals(address) || "null".equals(address)) {
                        address = null;
                    }
                    if ("".equals(reason) || "null".equals(reason)) {
                        reason = null;
                    }
                    Ban ban = new Ban(ID, name, address, reason, startDate, endDate);
                    if (ID != null) {
                        this.UUIDBan.put(ID, ban);
                    } else if (name != null) {
                        CommandBook.logger().finest("Converting " + name + "'s ban record to UUID...");
                        ID = UUIDUtil.convert(name);
                        if (ID != null) {
                            ban = new Ban(ID, name, address, reason, startDate, endDate);
                            this.UUIDBan.put(ID, ban);
                            needsSaved = true;
                            CommandBook.logger().finest("Success!");
                        } else {
                            if (this.nameBan == null) {
                                this.nameBan = new HashMap<String, Ban>();
                            }
                            this.nameBan.put(name, ban);
                            CommandBook.logger().warning(ban.toString() + " could not be converted!");
                        }
                    }
                    if (address != null) {
                        this.ipBan.put(address, ban);
                    }
                    this.bans.add(ban);
                }
                catch (IllegalArgumentException i) {
                    if (i instanceof NumberFormatException) {
                        CommandBook.logger().warning("Non-long long field found in ban!");
                        continue;
                    }
                    CommandBook.logger().warning("Invalid UUID field found in ban!");
                }
            }
            CommandBook.logger().info(this.bans.size() + " banned name(s) loaded.");
        }
        catch (FileNotFoundException streamReader) {
        }
        catch (IOException e) {
            this.nameBan = new HashMap<String, Ban>();
            this.ipBan = new HashMap<String, Ban>();
            CommandBook.logger().warning("Failed to load " + this.storageFile.getAbsolutePath() + ": " + e.getMessage());
            successful = false;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (needsSaved) {
            this.save();
        }
        return successful;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean save() {
        FileOutputStream output = null;
        boolean successful = true;
        try {
            output = new FileOutputStream(this.storageFile);
            CSVWriter writer = new CSVWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)output, "utf-8")));
            for (Ban ban : this.bans) {
                String[] line = new String[]{String.valueOf(ban.getID()), ban.getLastKnownAlias(), ban.getAddress(), ban.getReason(), String.valueOf(ban.getStart()), String.valueOf(ban.getEnd())};
                writer.writeNext(line);
            }
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            CommandBook.logger().warning("Failed to save " + this.storageFile.getAbsolutePath() + ": " + e.getMessage());
            successful = false;
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
        }
        return successful;
    }

    @Override
    public boolean unload() {
        for (Handler handler : this.auditLogger.getHandlers()) {
            if (!(handler instanceof FileHandler)) continue;
            handler.flush();
            handler.close();
            this.auditLogger.removeHandler(handler);
            return true;
        }
        return false;
    }

    @Override
    public boolean isBanned(UUID ID) {
        Ban ban = this.UUIDBan.get(ID);
        if (ban != null) {
            if (ban.getEnd() != 0L && ban.getEnd() - System.currentTimeMillis() <= 0L) {
                this.unban(ID, null, null, "Tempban expired");
                this.save();
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isBanned(InetAddress address) {
        Ban ban = this.ipBan.get(address.getHostAddress());
        if (ban != null) {
            if (ban.getEnd() != 0L && ban.getEnd() - System.currentTimeMillis() <= 0L) {
                this.unban(null, address.getHostAddress(), null, "Tempban expired");
                this.save();
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String getBannedMessage(UUID ID) {
        Ban ban = this.UUIDBan.get(ID);
        if (ban == null || ban.getReason() == null) {
            return "You are banned.";
        }
        return ban.getReason();
    }

    @Override
    public String getBannedMessage(String address) {
        Ban ban = this.ipBan.get(address);
        if (ban == null || ban.getReason() == null) {
            return "You are banned by IP.";
        }
        return ban.getReason();
    }

    @Override
    public void ban(Player player, CommandSender source, String reason, long end) {
        this.ban(player.getUniqueId(), player.getName(), player.getAddress().getAddress().getHostAddress(), source, reason, end);
    }

    @Override
    public void ban(UUID ID, String name, String address, CommandSender source, String reason, long end) {
        Ban oldBan;
        Validate.isTrue((ID != null || address != null ? 1 : 0) != 0, (String)"You must specify either an ID, or address");
        Ban ban = new Ban(ID, name, address, reason, System.currentTimeMillis(), end);
        if (ID != null) {
            oldBan = this.UUIDBan.remove(ID);
            if (oldBan != null) {
                this.bans.remove(oldBan);
            }
            this.UUIDBan.put(ID, ban);
        }
        if (address != null) {
            oldBan = this.ipBan.remove(address);
            if (oldBan != null) {
                this.bans.remove(oldBan);
            }
            this.ipBan.put(address, ban);
        }
        this.bans.add(ban);
        this.auditLogger.info(String.format("BAN: %s (%s) added %s: %s", source == null ? "Plugin" : ChatUtil.toUniqueName(source), source == null ? "local" : ServerUtil.toInetAddressString(source), ban.toString(), reason));
    }

    @Override
    public boolean unbanName(String name, CommandSender source, String reason) {
        if (this.nameBan == null || name == null || name.isEmpty()) {
            return false;
        }
        Ban ban = this.nameBan.remove(name.toLowerCase());
        if (ban != null) {
            this.bans.remove(ban);
            this.auditLogger.info(String.format("UNBAN: %s (%s) removed %s: %s", source == null ? "Plugin" : ChatUtil.toUniqueName(source), source == null ? "local" : ServerUtil.toInetAddressString(source), ban.toString(), reason));
            return true;
        }
        return false;
    }

    @Override
    public boolean unban(Player player, CommandSender source, String reason) {
        return this.unban(player.getUniqueId(), null, source, reason);
    }

    @Override
    public boolean unban(UUID ID, String address, CommandSender source, String reason) {
        Ban ban = null;
        if (ID != null) {
            ban = this.UUIDBan.remove(ID);
        }
        if (ban == null && address != null) {
            ban = this.ipBan.remove(address);
        }
        if (ban != null) {
            this.bans.remove(ban);
            this.auditLogger.info(String.format("UNBAN: %s (%s) removed %s: %s", source == null ? "Plugin" : ChatUtil.toUniqueName(source), source == null ? "local" : ServerUtil.toInetAddressString(source), ban.toString(), reason));
            return true;
        }
        return false;
    }

    @Override
    public void logKick(Player player, CommandSender source, String reason) {
        this.auditLogger.info(String.format("KICKED: %s (%s) kicked player '%s': %s", ChatUtil.toUniqueName(source), ServerUtil.toInetAddressString(source), player.getName(), reason));
    }

    @Override
    public void importFrom(BanDatabase bans) {
        for (Ban ban : bans) {
            boolean set = false;
            if (ban.getID() != null) {
                set = true;
                this.UUIDBan.put(ban.getID(), ban);
            }
            if (ban.getAddress() != null && !ban.getAddress().isEmpty()) {
                set = true;
                this.ipBan.put(ban.getAddress(), ban);
            }
            if (set) {
                this.bans.add(ban);
                continue;
            }
            CommandBook.logger().warning(ban.toString() + " could not be imported!");
        }
    }

    @Override
    public Ban getBanned(UUID ID) {
        return this.UUIDBan.get(ID);
    }

    @Override
    public Ban getBanned(String address) {
        return this.ipBan.get(address);
    }

    @Override
    public Iterator<Ban> iterator() {
        return new Iterator<Ban>(){
            private final Iterator<Ban> setIter;
            private Ban next;
            {
                this.setIter = CSVBanDatabase.this.bans.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.setIter.hasNext();
            }

            @Override
            public Ban next() {
                this.next = this.setIter.next();
                return this.next;
            }

            @Override
            public void remove() {
                CSVBanDatabase.this.unban(this.next.getID(), this.next.getAddress(), null, "Removed by iterator");
            }
        };
    }
}

