/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook.bans;

import java.util.UUID;

public class Ban {
    private final UUID ID;
    private String name;
    private final String address;
    private final String reason;
    private final long start;
    private final long end;

    public Ban(UUID ID, String name, String address, String reason, long start, long end) {
        this.ID = ID;
        this.name = name;
        this.address = address;
        this.reason = reason;
        this.start = start;
        this.end = end;
    }

    public UUID getID() {
        return this.ID;
    }

    public String getLastKnownAlias() {
        return this.name;
    }

    public void setLastAlias(String name) {
        this.name = name;
    }

    public String getAddress() {
        return this.address;
    }

    public String getReason() {
        return this.reason;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Ban)) {
            return false;
        }
        Ban ban = (Ban)other;
        return Ban.potentialNullEquals(this.name, ban.name) && Ban.potentialNullEquals(this.address, ban.address);
    }

    public static boolean potentialNullEquals(Object a, Object b) {
        return a == null && b == null || a != null && b != null && a.equals(b);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.address != null ? this.address.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BAN[");
        if (this.ID != null) {
            builder.append("(UUID: ").append(this.ID).append(")");
        }
        if (this.name != null) {
            builder.append("(LAST NAME: ").append(this.name).append(")");
        }
        if (this.address != null) {
            builder.append("(ADDRESS: ").append(this.address).append(")");
        }
        if (this.reason != null) {
            builder.append("(REASON: ").append(this.reason).append(")");
        }
        if (this.start != 0L) {
            builder.append("(START: ").append(this.start).append(")");
        }
        builder.append("(END: ");
        if (this.end != 0L) {
            builder.append(this.end);
        } else {
            builder.append("NEVER");
        }
        builder.append(")");
        builder.append("]");
        return builder.toString();
    }
}

