/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook;

import com.sk89q.commandbook.CommandBook;
import com.sk89q.commandbook.events.MOTDSendEvent;
import com.sk89q.commandbook.util.ChatUtil;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.zachsthings.libcomponents.ComponentInformation;
import com.zachsthings.libcomponents.bukkit.BukkitComponent;
import com.zachsthings.libcomponents.config.ConfigurationBase;
import com.zachsthings.libcomponents.config.Setting;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

@ComponentInformation(friendlyName="Stored Messages", desc="Handles stored messages, such as the MOTD and rules pages.")
public class StoredMessagesComponent
extends BukkitComponent
implements Listener {
    protected final Map<String, String> messages = new HashMap<String, String>();
    private LocalConfiguration config;

    public void enable() {
        this.config = new LocalConfiguration();
        this.loadMessages();
        CommandBook.registerEvents(this);
        this.registerCommands(Commands.class);
    }

    public void reload() {
        super.reload();
        this.loadMessages();
    }

    public void loadMessages() {
        this.configure(this.config);
        this.messages.put("motd", this.config.motd);
        this.messages.put("rules", this.config.rules);
    }

    public String getMessage(String id) {
        return this.messages.get(id);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        String motd = this.getMessage("motd");
        if (motd != null && motd.length() > 0) {
            CommandBook.callEvent((Event)new MOTDSendEvent((CommandSender)player));
            ChatUtil.sendMessage((CommandSender)player, ChatUtil.replaceColorMacros(ChatUtil.replaceMacros((CommandSender)player, motd)));
        }
    }

    public class Commands {
        @Command(aliases={"motd"}, usage="", desc="Show the message of the day", min=0, max=0)
        @CommandPermissions(value={"commandbook.motd"})
        public void motd(CommandContext args, CommandSender sender) throws CommandException {
            String motd = StoredMessagesComponent.this.getMessage("motd");
            if (motd == null || motd.length() < 1) {
                sender.sendMessage(ChatColor.RED + "MOTD not configured in CommandBook yet!");
            } else {
                CommandBook.callEvent((Event)new MOTDSendEvent(sender));
                ChatUtil.sendMessage(sender, ChatUtil.replaceColorMacros(ChatUtil.replaceMacros(sender, motd)));
            }
        }

        @Command(aliases={"rules"}, usage="", desc="Show the rules", min=0, max=0)
        @CommandPermissions(value={"commandbook.rules"})
        public void rules(CommandContext args, CommandSender sender) throws CommandException {
            String motd = StoredMessagesComponent.this.getMessage("rules");
            if (motd == null || motd.length() < 1) {
                sender.sendMessage(ChatColor.RED + "Rules not configured in CommandBook yet!");
            } else {
                ChatUtil.sendMessage(sender, ChatUtil.replaceColorMacros(ChatUtil.replaceMacros(sender, motd)));
            }
        }
    }

    private static class LocalConfiguration
    extends ConfigurationBase {
        @Setting(value="motd")
        public String motd = "Hello, `Y%name%`w.\nThe time now is `Y%time%`w and you're in world '%world%'.\n`2This is the default CommandBook MOTD! Adjust it in config.yml.\n`2See `bhttp://wiki.sk89q.com/wiki/CommandBook`2 for more configuration information and help!";
        @Setting(value="rules")
        public String rules = "- Be courteous and respect others.\n- Don't use any tools to give you an unfair advantage.\n`2This is the default CommandBook rules text! You can adjust it in config.yml.";

        private LocalConfiguration() {
        }
    }
}

