/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook;

import com.google.common.collect.Lists;
import com.sk89q.commandbook.CommandBook;
import com.sk89q.commandbook.util.ChatUtil;
import com.sk89q.commandbook.util.InputUtil;
import com.sk89q.commandbook.util.entity.player.PlayerUtil;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.zachsthings.libcomponents.ComponentInformation;
import com.zachsthings.libcomponents.bukkit.BukkitComponent;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@ComponentInformation(friendlyName="Player Commands", desc="Various player-related commands.")
public class PlayerComponent
extends BukkitComponent {
    public void enable() {
        this.registerCommands(Commands.class);
    }

    public class Commands {
        @Command(aliases={"gamemode", "gm"}, usage="[player] [gamemode]", desc="Change a player's gamemode", flags="c", min=0, max=2)
        public void gamemode(CommandContext args, CommandSender sender) throws CommandException {
            String message;
            Player player;
            GameMode mode = null;
            boolean change = false;
            if (args.argsLength() == 0) {
                player = PlayerUtil.checkPlayer(sender);
                mode = player.getGameMode();
            } else if (args.hasFlag('c')) {
                player = InputUtil.PlayerParser.matchSinglePlayer(sender, args.getString(0));
                mode = player.getGameMode();
            } else {
                String modeString;
                change = true;
                if (args.argsLength() == 1) {
                    modeString = args.getString(0);
                    player = PlayerUtil.checkPlayer(sender);
                } else {
                    try {
                        modeString = String.valueOf(args.getInteger(0));
                        player = InputUtil.PlayerParser.matchSinglePlayer(sender, args.getString(1));
                    }
                    catch (NumberFormatException e) {
                        player = InputUtil.PlayerParser.matchSinglePlayer(sender, args.getString(0));
                        modeString = args.getString(1);
                    }
                }
                CommandBook.inst().checkPermission(sender, "commandbook.gamemode." + (change ? "change" : "check") + (player != sender ? ".other" : ""));
                try {
                    mode = GameMode.valueOf((String)modeString.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    try {
                        mode = GameMode.getByValue((int)Integer.parseInt(modeString));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (mode == null) {
                    throw new CommandException("Unrecognized gamemode: " + modeString + ".");
                }
            }
            if (player == null || mode == null) {
                throw new CommandException("Something went wrong, please try again.");
            }
            if (change) {
                if (player.getGameMode() == mode) {
                    message = " already had gamemode " + mode.toString();
                    change = false;
                } else {
                    message = " changed to gamemode " + mode.toString();
                }
            } else {
                message = " currently has gamemode " + mode.toString();
            }
            if (change) {
                player.setGameMode(mode);
            }
            sender.sendMessage(ChatColor.YELLOW + "Player " + (CommandBook.inst().useDisplayNames ? player.getDisplayName() : player.getName()) + ChatColor.YELLOW + message + ".");
        }

        @Command(aliases={"heal"}, usage="[player]", desc="Heal a player", flags="s", min=0, max=1)
        @CommandPermissions(value={"commandbook.heal", "commandbook.heal.other"})
        public void heal(CommandContext args, CommandSender sender) throws CommandException {
            List<Player> targets = null;
            boolean included = false;
            if (args.argsLength() == 0) {
                targets = Lists.newArrayList((Object[])new Player[]{PlayerUtil.checkPlayer(sender)});
            } else if (args.argsLength() == 1) {
                targets = InputUtil.PlayerParser.matchPlayers(sender, args.getString(0));
            }
            for (Player player : targets) {
                if (player != sender) {
                    CommandBook.inst().checkPermission(sender, "commandbook.heal.other");
                    continue;
                }
                CommandBook.inst().checkPermission(sender, "commandbook.heal");
            }
            for (Player player : targets) {
                player.setHealth(player.getMaxHealth());
                player.setFoodLevel(20);
                player.setSaturation(20.0f);
                player.setExhaustion(0.0f);
                if (player.equals(sender)) {
                    player.sendMessage(ChatColor.YELLOW + "Healed!");
                    included = true;
                    continue;
                }
                if (args.hasFlag('s')) continue;
                player.sendMessage(ChatColor.YELLOW + "Healed by " + ChatUtil.toColoredName(sender, ChatColor.YELLOW) + ".");
            }
            if (!included) {
                sender.sendMessage(ChatColor.YELLOW.toString() + "Players healed.");
            }
        }

        @Command(aliases={"extinguish"}, usage="[player]", desc="Put out a fire on a player", flags="s", min=0, max=1)
        @CommandPermissions(value={"commandbook.extinguish", "commandbook.extinguish.other"})
        public void extinguish(CommandContext args, CommandSender sender) throws CommandException {
            boolean included = false;
            ArrayList targets = args.argsLength() > 0 ? InputUtil.PlayerParser.matchPlayers(sender, args.getString(0)) : Lists.newArrayList((Object[])new Player[]{PlayerUtil.checkPlayer(sender)});
            for (Player player : targets) {
                if (player != sender) {
                    CommandBook.inst().checkPermission(sender, "commandbook.extinguish.other");
                    continue;
                }
                CommandBook.inst().checkPermission(sender, "commandbook.extinguish");
            }
            for (Player player : targets) {
                if (player.getFireTicks() < 1) {
                    player.sendMessage(ChatColor.RED + ChatUtil.toColoredName((CommandSender)player, ChatColor.RED) + " was not on fire!");
                    continue;
                }
                player.setFireTicks(0);
                if (player.equals(sender)) {
                    player.sendMessage(ChatColor.YELLOW + "Fire extinguished!");
                    included = true;
                    continue;
                }
                if (args.hasFlag('s')) continue;
                player.sendMessage(ChatColor.YELLOW + "Fire extinguished by " + ChatUtil.toColoredName(sender, ChatColor.YELLOW) + ".");
            }
            if (!included) {
                sender.sendMessage(ChatColor.YELLOW.toString() + "Fires extinguished.");
            }
        }

        @Command(aliases={"slay"}, usage="[player]", desc="Slay a player", flags="s", min=0, max=1)
        @CommandPermissions(value={"commandbook.slay"})
        public void slay(CommandContext args, CommandSender sender) throws CommandException {
            List<Player> targets = null;
            boolean included = false;
            if (args.argsLength() == 0) {
                targets = Lists.newArrayList((Object[])new Player[]{PlayerUtil.checkPlayer(sender)});
            } else if (args.argsLength() == 1) {
                targets = InputUtil.PlayerParser.matchPlayers(sender, args.getString(0));
            }
            for (Player player : targets) {
                if (player != sender) {
                    CommandBook.inst().checkPermission(sender, "commandbook.slay.other");
                    continue;
                }
                CommandBook.inst().checkPermission(sender, "commandbook.slay");
            }
            for (Player player : targets) {
                player.setHealth(0.0);
                if (player.equals(sender)) {
                    player.sendMessage(ChatColor.YELLOW + "Slain!");
                    included = true;
                    continue;
                }
                if (args.hasFlag('s')) continue;
                player.sendMessage(ChatColor.YELLOW + "Slain by " + ChatUtil.toColoredName(sender, ChatColor.YELLOW) + ".");
            }
            if (!included) {
                sender.sendMessage(ChatColor.YELLOW.toString() + "Players slain.");
            }
        }

        @Command(aliases={"locate"}, usage="[player]", desc="Locate a player", max=1)
        @CommandPermissions(value={"commandbook.locate"})
        public void locate(CommandContext args, CommandSender sender) throws CommandException {
            Player player = PlayerUtil.checkPlayer(sender);
            if (args.argsLength() == 0) {
                player.setCompassTarget(player.getWorld().getSpawnLocation());
                sender.sendMessage(ChatColor.YELLOW.toString() + "Compass reset to spawn.");
            } else {
                Player target = InputUtil.PlayerParser.matchSinglePlayer(sender, args.getString(0));
                player.setCompassTarget(target.getLocation());
                sender.sendMessage(ChatColor.YELLOW.toString() + "Compass repointed.");
            }
        }
    }
}

