/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook;

import com.sk89q.commandbook.AFKComponent;
import com.sk89q.commandbook.CommandBook;
import com.sk89q.commandbook.events.CommandSenderMessageEvent;
import com.sk89q.commandbook.events.SharedMessageEvent;
import com.sk89q.commandbook.session.AdministrativeSession;
import com.sk89q.commandbook.session.SessionComponent;
import com.sk89q.commandbook.session.UserSession;
import com.sk89q.commandbook.util.ChatUtil;
import com.sk89q.commandbook.util.InputUtil;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.zachsthings.libcomponents.ComponentInformation;
import com.zachsthings.libcomponents.Depend;
import com.zachsthings.libcomponents.InjectComponent;
import com.zachsthings.libcomponents.bukkit.BasePlugin;
import com.zachsthings.libcomponents.bukkit.BukkitComponent;
import com.zachsthings.libcomponents.config.ConfigurationBase;
import com.zachsthings.libcomponents.config.ConfigurationNode;
import com.zachsthings.libcomponents.config.Setting;
import java.util.HashSet;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;

@ComponentInformation(friendlyName="Messaging", desc="Commands that involve direct player <-> player or player <-> admincommunication are handled through this component.")
@Depend(components={SessionComponent.class})
public class MessagingComponent
extends BukkitComponent
implements Listener {
    @InjectComponent
    private SessionComponent sessions;
    private LocalConfiguration config;

    public void enable() {
        this.config = (LocalConfiguration)this.configure(new LocalConfiguration());
        this.registerCommands(Commands.class);
        CommandBook.registerEvents(this);
    }

    public void reload() {
        super.reload();
        this.configure(this.config);
    }

    public void messagePlayer(CommandSender sender, String target, String message) throws CommandException {
        CommandSender receiver = InputUtil.PlayerParser.matchPlayerOrConsole(sender, target);
        UserSession receiverSession = this.sessions.getSession(UserSession.class, receiver);
        AFKComponent.AFKSession afkSession = this.sessions.getSession(AFKComponent.AFKSession.class, receiver);
        if (afkSession.isAFK()) {
            String status = afkSession.getIdleStatus();
            sender.sendMessage(this.config.pmColor + ChatUtil.toColoredName(receiver, this.config.pmColor) + " is afk. They might not see your message." + (status.trim().length() == 0 ? "" : " (" + status + ")"));
        }
        receiver.sendMessage(this.config.pmColor + "(From " + ChatUtil.toColoredName(sender, this.config.pmColor) + "): " + this.config.pmTextColor + message);
        sender.sendMessage(this.config.pmColor + "(To " + ChatUtil.toColoredName(receiver, this.config.pmColor) + "): " + this.config.pmTextColor + message);
        CommandBook.logger().info("(PM) " + ChatUtil.toColoredName(sender, ChatColor.RESET) + " -> " + ChatUtil.toColoredName(receiver, ChatColor.RESET) + ": " + message);
        this.sessions.getSession(UserSession.class, sender).setLastRecipient(receiver);
        receiverSession.setNewLastRecipient(sender);
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent event) {
        String message;
        int spaceIndex;
        if (this.sessions.getSession(AdministrativeSession.class, (CommandSender)event.getPlayer()).isMute()) {
            event.getPlayer().sendMessage(ChatColor.RED + "You are muted.");
            event.setCancelled(true);
        } else if (event.getMessage().startsWith("@") && this.config.twitterStyle && (spaceIndex = (message = event.getMessage()).indexOf(" ")) > -1) {
            try {
                String name = message.substring(1, spaceIndex);
                if (name.length() <= 0) {
                    return;
                }
                this.messagePlayer((CommandSender)event.getPlayer(), name, message.substring(spaceIndex + 1));
            }
            catch (CommandException e) {
                event.getPlayer().sendMessage(ChatColor.RED + e.getMessage());
            }
            event.setCancelled(true);
        }
    }

    public class Commands {
        @Command(aliases={"me"}, usage="<message...>", desc="Send an action message", min=1, max=-1)
        @CommandPermissions(value={"commandbook.say.me"})
        public void me(CommandContext args, CommandSender sender) throws CommandException {
            if (sender instanceof Player && MessagingComponent.this.sessions.getSession(AdministrativeSession.class, sender).isMute()) {
                sender.sendMessage(ChatColor.RED + "You are muted.");
                return;
            }
            String name = ChatUtil.toColoredName(sender, ChatColor.YELLOW);
            String msg = args.getJoinedStrings(0);
            BasePlugin.callEvent((Event)new SharedMessageEvent(name + " " + msg));
            BasePlugin.server().broadcastMessage("* " + name + " " + msg);
        }

        @Command(aliases={"say"}, usage="<message...>", desc="Send a message", min=1, max=-1)
        @CommandPermissions(value={"commandbook.say"})
        public void say(CommandContext args, CommandSender sender) throws CommandException {
            if (sender instanceof Player && MessagingComponent.this.sessions.getSession(AdministrativeSession.class, (CommandSender)((Player)sender)).isMute()) {
                sender.sendMessage(ChatColor.RED + "You are muted.");
                return;
            }
            String msg = args.getJoinedStrings(0);
            if (sender instanceof Player && ((AsyncPlayerChatEvent)BasePlugin.callEvent((Event)new AsyncPlayerChatEvent(false, (Player)sender, msg, new HashSet(BasePlugin.server().getOnlinePlayers())))).isCancelled()) {
                return;
            }
            BasePlugin.callEvent((Event)new CommandSenderMessageEvent(sender, msg));
            if (sender instanceof Player) {
                BasePlugin.server().broadcastMessage("<" + ChatUtil.toColoredName(sender, ChatColor.RESET) + "> " + args.getJoinedStrings(0));
            } else {
                BasePlugin.server().broadcastMessage(ChatUtil.replaceColorMacros(((MessagingComponent)MessagingComponent.this).config.consoleSayFormat).replace("%s", args.getJoinedStrings(0)));
            }
        }

        @Command(aliases={"msg", "message", "whisper", "pm", "tell", "w"}, usage="<target> <message...>", desc="Private message a user", min=2, max=-1)
        @CommandPermissions(value={"commandbook.msg"})
        public void msg(CommandContext args, CommandSender sender) throws CommandException {
            MessagingComponent.this.messagePlayer(sender, args.getString(0), args.getJoinedStrings(1));
        }

        @Command(aliases={"reply", "r"}, usage="<message...>", desc="Reply to last user", min=1, max=-1)
        @CommandPermissions(value={"commandbook.msg"})
        public void reply(CommandContext args, CommandSender sender) throws CommandException {
            String lastRecipient = MessagingComponent.this.sessions.getSession(UserSession.class, sender).getLastRecipient();
            if (lastRecipient == null) {
                throw new CommandException("You haven't messaged anyone.");
            }
            MessagingComponent.this.messagePlayer(sender, lastRecipient, args.getJoinedStrings(0));
        }

        @Command(aliases={"mute"}, usage="<target>", desc="Mute a player", flags="o", min=1, max=1)
        @CommandPermissions(value={"commandbook.mute"})
        public void mute(CommandContext args, CommandSender sender) throws CommandException {
            Player player = InputUtil.PlayerParser.matchSinglePlayer(sender, args.getString(0));
            if (!(!CommandBook.inst().hasPermission((CommandSender)player, "commandbook.mute.exempt") || args.hasFlag('o') && CommandBook.inst().hasPermission(sender, "commandbook.mute.exempt.override"))) {
                throw new CommandException("Player " + ChatUtil.toName(sender) + " is exempt from being muted!");
            }
            if (!MessagingComponent.this.sessions.getSession(AdministrativeSession.class, (CommandSender)player).setMute(true)) {
                if (player != sender) {
                    player.sendMessage(ChatColor.YELLOW + "You've been muted by " + ChatUtil.toColoredName(sender, ChatColor.YELLOW));
                }
            } else {
                throw new CommandException("Player " + ChatUtil.toName((CommandSender)player) + " is already muted!");
            }
            sender.sendMessage(ChatColor.YELLOW + "You've muted " + ChatUtil.toColoredName((CommandSender)player, ChatColor.YELLOW));
        }

        @Command(aliases={"unmute"}, usage="<target>", desc="Unmute a player", min=1, max=1)
        @CommandPermissions(value={"commandbook.mute"})
        public void unmute(CommandContext args, CommandSender sender) throws CommandException {
            Player player = InputUtil.PlayerParser.matchSinglePlayer(sender, args.getString(0));
            if (MessagingComponent.this.sessions.getSession(AdministrativeSession.class, (CommandSender)player).setMute(false)) {
                if (player != sender) {
                    player.sendMessage(ChatColor.YELLOW + "You've been unmuted by " + ChatUtil.toColoredName(sender, ChatColor.YELLOW));
                }
            } else {
                throw new CommandException("Player " + ChatUtil.toName((CommandSender)player) + " was not muted!");
            }
            sender.sendMessage(ChatColor.YELLOW + "You've unmuted " + ChatUtil.toColoredName((CommandSender)player, ChatColor.YELLOW));
        }

        @Command(aliases={"broadcast"}, usage="<message...>", desc="Broadcast a message", min=1, max=-1)
        @CommandPermissions(value={"commandbook.broadcast"})
        public void broadcast(CommandContext args, CommandSender sender) throws CommandException {
            BasePlugin.server().broadcastMessage(ChatUtil.replaceColorMacros(((MessagingComponent)MessagingComponent.this).config.broadcastFormat).replace("%s", args.getJoinedStrings(0)));
        }
    }

    private static class LocalConfiguration
    extends ConfigurationBase {
        @Setting(value="console-say-format")
        public String consoleSayFormat = "<`r*Console`w> %s";
        @Setting(value="broadcast-format")
        public String broadcastFormat = "`r[Broadcast] %s";
        @Setting(value="pm-color")
        private String pmColorString = "GRAY";
        @Setting(value="pm-text-color")
        private String pmTextColorString = "RESET";
        public ChatColor pmColor = ChatColor.GRAY;
        public ChatColor pmTextColor = ChatColor.RESET;
        @Setting(value="twitter-style")
        public boolean twitterStyle = true;

        private LocalConfiguration() {
        }

        public void load(ConfigurationNode node) {
            super.load(node);
            boolean error = false;
            try {
                this.pmColor = ChatColor.valueOf((String)this.pmColorString);
            }
            catch (IllegalArgumentException e) {
                CommandBook.logger().warning("Unknown PM Color  '" + this.pmColorString + "'! Resetting to GRAY");
                this.pmColor = ChatColor.GRAY;
                this.pmColorString = "GRAY";
                error = true;
            }
            try {
                this.pmTextColor = ChatColor.valueOf((String)this.pmTextColorString);
            }
            catch (IllegalArgumentException e) {
                CommandBook.logger().warning("Unknown PM Color  '" + this.pmTextColorString + "'! Resetting to GRAY");
                this.pmTextColor = ChatColor.GRAY;
                this.pmTextColorString = "GRAY";
                error = true;
            }
            if (error) {
                this.save(node);
            }
        }
    }
}

