/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook;

import com.google.common.collect.Lists;
import com.sk89q.commandbook.CommandBook;
import com.sk89q.commandbook.commands.PaginatedResult;
import com.sk89q.commandbook.util.ChatUtil;
import com.sk89q.commandbook.util.InputUtil;
import com.sk89q.commandbook.util.entity.player.PlayerUtil;
import com.sk89q.commandbook.util.item.InventoryUtil;
import com.sk89q.commandbook.util.item.ItemUtil;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.worldedit.blocks.BaseItem;
import com.sk89q.worldedit.world.item.ItemType;
import com.sk89q.worldedit.world.item.ItemTypes;
import com.zachsthings.libcomponents.ComponentInformation;
import com.zachsthings.libcomponents.bukkit.BukkitComponent;
import com.zachsthings.libcomponents.config.ConfigurationBase;
import com.zachsthings.libcomponents.config.Setting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

@ComponentInformation(friendlyName="Inventory", desc="Inventory-related commands, such as /give and /clear, are handled in this component.")
public class InventoryComponent
extends BukkitComponent {
    protected LocalConfiguration config;

    public void enable() {
        this.config = (LocalConfiguration)this.configure(new LocalConfiguration());
        this.registerCommands(Commands.class);
    }

    public void reload() {
        super.reload();
        this.configure(this.config);
    }

    public void checkAllowedItem(CommandSender sender, BaseItem itemStack) throws CommandException {
        ItemType itemType = itemStack.getType();
        if (itemType == null || itemType == ItemTypes.AIR) {
            throw new CommandException("Non-existent item specified.");
        }
        if (CommandBook.inst().hasPermission(sender, "commandbook.override.any-item")) {
            return;
        }
        String itemId = itemType.getId();
        String namespacedPermission = itemId.replace(":", ".");
        boolean hasPermissions = CommandBook.inst().hasPermission(sender, "commandbook.items." + namespacedPermission);
        if (hasPermissions) {
            return;
        }
        if (this.config.useItemPermissionsOnly) {
            throw new CommandException("That item is not allowed.");
        }
        if (this.config.allowedItems.size() > 0 && !this.config.allowedItems.contains(itemId)) {
            throw new CommandException("That item is not allowed.");
        }
        if (this.config.disallowedItems.contains(itemId)) {
            throw new CommandException("That item is disallowed.");
        }
    }

    private BaseItem matchItem(String name) throws CommandException {
        return ItemUtil.getCommandItem(name);
    }

    public class Commands {
        @Command(aliases={"item", "i"}, usage="[target] <item[:data][|enchantment:level]> [amount]", desc="Give an item", flags="do", min=1, max=3)
        @CommandPermissions(value={"commandbook.give"})
        public void item(CommandContext args, CommandSender sender) throws CommandException {
            BaseItem item = null;
            int amt = InventoryComponent.this.config.defaultItemStackSize;
            List<Object> targets = null;
            if (args.argsLength() == 1) {
                item = InventoryComponent.this.matchItem(args.getString(0));
                targets = Lists.newArrayList((Object[])new Player[]{PlayerUtil.checkPlayer(sender)});
            } else if (args.argsLength() == 2) {
                item = InventoryComponent.this.matchItem(args.getString(0));
                amt = args.getInteger(1);
                targets = Lists.newArrayList((Object[])new Player[]{PlayerUtil.checkPlayer(sender)});
            } else if (args.argsLength() == 3) {
                item = InventoryComponent.this.matchItem(args.getString(1));
                amt = args.getInteger(2);
                targets = InputUtil.PlayerParser.matchPlayers(sender, args.getString(0));
                for (Player player : targets) {
                    if (player == sender) continue;
                    CommandBook.inst().checkPermission(sender, "commandbook.give.other");
                }
            }
            if (item == null) {
                throw new CommandException("Something went wrong parsing the item info!");
            }
            InventoryUtil.giveItem(sender, item, amt, (Collection<Player>)targets, InventoryComponent.this, args.hasFlag('d'), args.hasFlag('o'));
        }

        @Command(aliases={"give"}, usage="[-d] <target> <item[:data]> [amount]", desc="Give an item", flags="do", min=2, max=3)
        @CommandPermissions(value={"commandbook.give", "commandbook.give.other"})
        public void give(CommandContext args, CommandSender sender) throws CommandException {
            BaseItem item = null;
            int amt = InventoryComponent.this.config.defaultItemStackSize;
            List<Player> targets = null;
            if (args.argsLength() == 2) {
                targets = InputUtil.PlayerParser.matchPlayers(sender, args.getString(0));
                item = InventoryComponent.this.matchItem(args.getString(1));
            } else if (args.argsLength() == 3) {
                targets = InputUtil.PlayerParser.matchPlayers(sender, args.getString(0));
                item = InventoryComponent.this.matchItem(args.getString(1));
                amt = args.getInteger(2);
            }
            for (Player target : targets) {
                if (target != sender) {
                    CommandBook.inst().checkPermission(sender, "commandbook.give.other");
                    continue;
                }
                CommandBook.inst().checkPermission(sender, "commandbook.give");
            }
            if (item == null) {
                throw new CommandException("Something went wrong parsing the item info!");
            }
            InventoryUtil.giveItem(sender, item, amt, targets, InventoryComponent.this, args.hasFlag('d'), args.hasFlag('o'));
        }

        @Command(aliases={"clear"}, usage="[target]", desc="Clear your inventory", flags="as", min=0, max=1)
        @CommandPermissions(value={"commandbook.clear"})
        public void clear(CommandContext args, CommandSender sender) throws CommandException {
            boolean clearAll = args.hasFlag('a');
            boolean clearSingle = args.hasFlag('s');
            boolean included = false;
            ArrayList targets = args.argsLength() == 0 ? Lists.newArrayList((Object[])new Player[]{PlayerUtil.checkPlayer(sender)}) : InputUtil.PlayerParser.matchPlayers(sender, args.getString(0));
            for (Player player : targets) {
                if (sender == player) continue;
                CommandBook.inst().checkPermission(sender, "commandbook.clear.other");
                break;
            }
            for (Player player : targets) {
                PlayerInventory inventory = player.getInventory();
                if (clearSingle) {
                    player.setItemInHand(null);
                } else {
                    int i;
                    int n = i = clearAll ? 0 : 9;
                    while (i < 36) {
                        inventory.setItem(i, null);
                        ++i;
                    }
                    if (clearAll) {
                        for (i = 36; i <= 39; ++i) {
                            inventory.setItem(i, null);
                        }
                    }
                }
                if (player.equals(sender)) {
                    if (clearAll) {
                        player.sendMessage(ChatColor.YELLOW + "Your inventory has been cleared.");
                    } else {
                        player.sendMessage(ChatColor.YELLOW + "Your inventory has been cleared. Use -a to clear ALL.");
                    }
                    included = true;
                    continue;
                }
                player.sendMessage(ChatColor.YELLOW + "Your inventory has been cleared by " + ChatUtil.toColoredName(sender, ChatColor.YELLOW));
            }
            if (!included) {
                sender.sendMessage(ChatColor.YELLOW + "Inventories cleared.");
            }
        }

        @Command(aliases={"more"}, usage="[player]", desc="Gets more of an item", flags="aio", min=0, max=1)
        @CommandPermissions(value={"commandbook.more"})
        public void more(CommandContext args, CommandSender sender) throws CommandException {
            boolean moreAll = args.hasFlag('a');
            boolean infinite = args.hasFlag('i');
            boolean overrideStackSize = args.hasFlag('o');
            if (infinite) {
                CommandBook.inst().checkPermission(sender, "commandbook.more.infinite");
            } else if (overrideStackSize) {
                CommandBook.inst().checkPermission(sender, "commandbook.override.maxstacksize");
            }
            boolean included = false;
            ArrayList targets = args.argsLength() == 0 ? Lists.newArrayList((Object[])new Player[]{PlayerUtil.checkPlayer(sender)}) : InputUtil.PlayerParser.matchPlayers(sender, args.getString(0));
            for (Player player : targets) {
                if (player != sender) {
                    CommandBook.inst().checkPermission(sender, "commandbook.more.other");
                    continue;
                }
                CommandBook.inst().checkPermission(sender, "commandbook.more");
            }
            for (Player player : targets) {
                PlayerInventory inventory = player.getInventory();
                if (moreAll) {
                    for (int i = 0; i < 39; ++i) {
                        ItemUtil.expandStack(inventory.getItem(i), infinite, overrideStackSize);
                    }
                } else {
                    ItemUtil.expandStack(player.getItemInHand(), infinite, overrideStackSize);
                }
                if (player.equals(sender)) {
                    player.sendMessage(ChatColor.YELLOW + "Your item(s) has been expanded in stack size.");
                    included = true;
                    continue;
                }
                player.sendMessage(ChatColor.YELLOW + "Your item(s) has been expanded in stack size by " + ChatUtil.toColoredName(sender, ChatColor.YELLOW));
            }
            if (!included) {
                sender.sendMessage(ChatColor.YELLOW + "Stack sizes increased.");
            }
        }

        @Command(aliases={"take"}, usage="<target> <item[:data]> [amount]", desc="Take an item", flags="", min=2, max=3)
        @CommandPermissions(value={"commandbook.take"})
        public void take(CommandContext args, CommandSender sender) throws CommandException {
            BaseItem item = null;
            int amt = InventoryComponent.this.config.defaultItemStackSize;
            Player target = null;
            if (args.argsLength() == 2) {
                target = InputUtil.PlayerParser.matchSinglePlayer(sender, args.getString(0));
                item = InventoryComponent.this.matchItem(args.getString(1));
            } else if (args.argsLength() == 3) {
                target = InputUtil.PlayerParser.matchSinglePlayer(sender, args.getString(0));
                item = InventoryComponent.this.matchItem(args.getString(1));
                amt = args.getInteger(2);
            }
            if (target != sender) {
                CommandBook.inst().checkPermission(sender, "commandbook.take.other");
            } else {
                CommandBook.inst().checkPermission(sender, "commandbook.take");
            }
            if (item == null) {
                throw new CommandException("Something went wrong parsing the item info!");
            }
            InventoryUtil.takeItem(sender, item, amt, target);
        }

        @Command(aliases={"stack"}, usage="", desc="Stack items", max=0)
        @CommandPermissions(value={"commandbook.stack"})
        public void stack(CommandContext args, CommandSender sender) throws CommandException {
            Player player = PlayerUtil.checkPlayer(sender);
            boolean ignoreMax = CommandBook.inst().hasPermission((CommandSender)player, "commandbook.stack.illegitimate");
            boolean ignoreDamaged = CommandBook.inst().hasPermission((CommandSender)player, "commandbook.stack.damaged");
            ItemStack[] items = player.getInventory().getContents();
            int len = items.length;
            int affected = 0;
            block0: for (int i = 0; i < len; ++i) {
                int max;
                ItemStack item = items[i];
                if (item == null || item.getAmount() <= 0 || !ignoreMax && item.getMaxStackSize() == 1) continue;
                int n = max = ignoreMax ? 64 : item.getMaxStackSize();
                if (item.getAmount() >= max) continue;
                int needed = max - item.getAmount();
                for (int j = i + 1; j < len; ++j) {
                    ItemStack item2 = items[j];
                    if (item2 == null || item2.getAmount() <= 0 || !ignoreMax && item.getMaxStackSize() == 1 || !item2.isSimilar(item)) continue;
                    if (item2.getAmount() > needed) {
                        item.setAmount(64);
                        item2.setAmount(item2.getAmount() - needed);
                        continue block0;
                    }
                    items[j] = null;
                    item.setAmount(item.getAmount() + item2.getAmount());
                    needed = 64 - item.getAmount();
                    ++affected;
                }
            }
            if (affected > 0) {
                player.getInventory().setContents(items);
            }
            player.sendMessage(ChatColor.YELLOW + "Items compacted into stacks!");
        }

        @Command(aliases={"repair"}, usage="[targets]", desc="Repair items", flags="ahe", min=0, max=1)
        @CommandPermissions(value={"commandbook.repair"})
        public void repair(CommandContext args, CommandSender sender) throws CommandException {
            boolean repairAll = args.hasFlag('a');
            boolean repairHotbar = args.hasFlag('h');
            boolean repairEquipment = args.hasFlag('e');
            boolean included = false;
            ArrayList targets = args.argsLength() == 0 ? Lists.newArrayList((Object[])new Player[]{PlayerUtil.checkPlayer(sender)}) : InputUtil.PlayerParser.matchPlayers(sender, args.getString(0));
            for (Player player : targets) {
                if (sender == player) continue;
                CommandBook.inst().checkPermission(sender, "commandbook.repair.other");
                break;
            }
            for (Player player : targets) {
                PlayerInventory inventory = player.getInventory();
                if (!(repairAll || repairHotbar || repairEquipment)) {
                    ItemStack stack = player.getItemInHand();
                    ItemMeta stackMeta = stack.getItemMeta();
                    if (stackMeta instanceof Damageable) {
                        ((Damageable)stackMeta).setDamage(0);
                        stack.setItemMeta(stackMeta);
                    }
                } else {
                    ItemMeta stackMeta;
                    ItemStack stack;
                    if (repairAll || repairHotbar) {
                        int i;
                        int n = i = repairAll ? 36 : 8;
                        while (i >= 0) {
                            stack = inventory.getItem(i);
                            if (stack != null && (stackMeta = stack.getItemMeta()) instanceof Damageable) {
                                ((Damageable)stackMeta).setDamage(0);
                                stack.setItemMeta(stackMeta);
                            }
                            --i;
                        }
                    }
                    if (repairAll || repairEquipment) {
                        for (int i = 36; i <= 39; ++i) {
                            stack = inventory.getItem(i);
                            if (stack == null || !((stackMeta = stack.getItemMeta()) instanceof Damageable)) continue;
                            ((Damageable)stackMeta).setDamage(0);
                            stack.setItemMeta(stackMeta);
                        }
                    }
                }
                if (player.equals(sender)) {
                    if (repairAll || repairHotbar || repairEquipment) {
                        player.sendMessage(ChatColor.YELLOW + "Your items have been repaired.");
                    } else {
                        player.sendMessage(ChatColor.YELLOW + "Your held item has been repaired. Use -a to repair all.");
                    }
                    included = true;
                    continue;
                }
                player.sendMessage(ChatColor.YELLOW + "One or more of your item(s) has been repaired by " + ChatUtil.toColoredName(sender, ChatColor.YELLOW));
            }
            if (!included) {
                sender.sendMessage(ChatColor.YELLOW + "Items repaired.");
            }
        }

        @Command(aliases={"enchantments", "listenchant", "lsenchant"}, desc="List available enchantments", usage="[-p page]", flags="p:")
        public void enchantments(CommandContext args, CommandSender sender) throws CommandException {
            new PaginatedResult<Enchantment>(ChatColor.GOLD + "Enchantments"){

                @Override
                public String format(Enchantment entry) {
                    return ChatColor.BLUE + entry.getName().toUpperCase() + ChatColor.YELLOW + " (ID: " + ChatColor.WHITE + entry.getKey() + ChatColor.YELLOW + ", Max Level: " + ChatColor.WHITE + entry.getMaxLevel() + ChatColor.YELLOW + ')';
                }
            }.display(sender, Arrays.asList(Enchantment.values()), args.getFlagInteger('p', 1));
        }
    }

    private static class LocalConfiguration
    extends ConfigurationBase {
        @Setting(value="item-permissions-only")
        public boolean useItemPermissionsOnly;
        @Setting(value="allowed-items")
        public Set<String> allowedItems = Collections.emptySet();
        @Setting(value="disllowed-items")
        public Set<String> disallowedItems = Collections.emptySet();
        @Setting(value="default-item-stack-size")
        public int defaultItemStackSize = 1;

        private LocalConfiguration() {
        }
    }
}

