/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook;

import com.sk89q.commandbook.CommandBook;
import com.sk89q.commandbook.commands.PaginatedResult;
import com.sk89q.commandbook.session.PersistentSession;
import com.sk89q.commandbook.session.SessionComponent;
import com.sk89q.commandbook.util.InputUtil;
import com.sk89q.commandbook.util.NestUtil;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.NestedCommand;
import com.zachsthings.libcomponents.ComponentInformation;
import com.zachsthings.libcomponents.Depend;
import com.zachsthings.libcomponents.InjectComponent;
import com.zachsthings.libcomponents.bukkit.BukkitComponent;
import com.zachsthings.libcomponents.config.ConfigurationBase;
import com.zachsthings.libcomponents.config.Setting;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.plugin.Plugin;

@ComponentInformation(friendlyName="Warmups and Cooldowns", desc="Allows warmups and cooldowns for commands, specified in seconds.")
@Depend(components={SessionComponent.class})
public class CooldownsComponent
extends BukkitComponent
implements Listener,
Runnable {
    @InjectComponent
    private SessionComponent sessions;
    private LocalConfiguration config;
    private static ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(5);
    private static final SimpleDateFormat timeFormat = new SimpleDateFormat("mm:ss");

    public void enable() {
        this.config = (LocalConfiguration)this.configure(new LocalConfiguration());
        CommandBook.registerEvents(this);
        this.registerCommands(Commands.class);
        scheduler.scheduleAtFixedRate(this, 1L, 1L, TimeUnit.SECONDS);
    }

    public void reload() {
        super.reload();
        this.configure(this.config);
    }

    public void disable() {
        scheduler.shutdown();
    }

    private static String firstWord(String str) {
        int spaceIndex = str.indexOf(" ");
        if (spaceIndex == -1) {
            return str;
        }
        return str.substring(0, spaceIndex);
    }

    private static String titleCase(String input) {
        StringBuilder ret = new StringBuilder();
        for (String word : input.split(" ")) {
            if (ret.length() > 0) {
                ret.append(" ");
            }
            if (ret.length() == 0 || word.length() > 2) {
                ret.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1));
                continue;
            }
            ret.append(word);
        }
        return ret.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String formatTime(int timeInSeconds, TimeUnit unit) {
        SimpleDateFormat simpleDateFormat = timeFormat;
        synchronized (simpleDateFormat) {
            return timeFormat.format(new Date(unit.toMillis(timeInSeconds)));
        }
    }

    @Override
    public void run() {
        for (CooldownState state : this.sessions.getSessions(CooldownState.class).values()) {
            Map.Entry<String, Object> entry;
            HashSet<String> visitedCooldowns = new HashSet<String>();
            Iterator<Map.Entry<String, Object>> i = state.cooldownCommands.entrySet().iterator();
            while (i.hasNext()) {
                entry = i.next();
                Integer cooldownTime = NestUtil.getNestedMap(this.config.registeredActions, entry.getKey()).get("cooldown");
                if (cooldownTime == null) {
                    i.remove();
                    continue;
                }
                if ((Integer)entry.getValue() <= cooldownTime) {
                    entry.setValue((Integer)entry.getValue() + 1);
                }
                visitedCooldowns.add(entry.getKey());
            }
            i = state.warmupCommands.entrySet().iterator();
            while (i.hasNext()) {
                entry = i.next();
                Integer warmupTime = NestUtil.getNestedMap(this.config.registeredActions, entry.getKey()).get("warmup");
                if (warmupTime == null) {
                    i.remove();
                    continue;
                }
                if (visitedCooldowns.contains(entry.getKey())) continue;
                if (((WarmupInfo)entry.getValue()).remainingTime < warmupTime) {
                    ++((WarmupInfo)entry.getValue()).remainingTime;
                    continue;
                }
                if (((WarmupInfo)entry.getValue()).remainingTime != warmupTime) continue;
                final CommandSender owner = state.getOwner();
                if (owner != null) {
                    CommandBook.server().getScheduler().callSyncMethod((Plugin)CommandBook.inst(), (Callable)new Callable<Boolean>(){

                        @Override
                        public Boolean call() {
                            return CommandBook.server().dispatchCommand(owner, ((WarmupInfo)entry.getValue()).fullCommand);
                        }
                    });
                }
                i.remove();
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void playerHandler(PlayerCommandPreprocessEvent event) {
        if (!this.checkCooldown((CommandSender)event.getPlayer(), event.getMessage().substring(1)) || !this.checkWarmup((CommandSender)event.getPlayer(), event.getMessage().substring(1))) {
            event.setCancelled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkCooldown(CommandSender sender, String command) {
        CooldownState state = this.sessions.getSession(CooldownState.class, sender);
        command = CooldownsComponent.firstWord(command);
        Map<String, Integer> map = state.cooldownCommands;
        synchronized (map) {
            Map<String, Integer> storedTimes = this.config.registeredActions.get(command);
            if (storedTimes == null) {
                return true;
            }
            Integer requiredCooldownTime = storedTimes.get("cooldown");
            if (requiredCooldownTime == null) {
                return true;
            }
            Integer passedCooldownTime = state.cooldownCommands.get(command);
            if (passedCooldownTime == null) {
                passedCooldownTime = 0;
                state.cooldownCommands.put(command, passedCooldownTime);
            }
            if (passedCooldownTime >= requiredCooldownTime || CommandBook.inst().hasPermission(sender, "commandbook.cooldown.override." + command)) {
                state.cooldownCommands.remove(command);
                return true;
            }
            sender.sendMessage(ChatColor.YELLOW + "The command '" + command + "' has a remaining cooldown of " + CooldownsComponent.formatTime(requiredCooldownTime - passedCooldownTime, TimeUnit.SECONDS) + " seconds.");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkWarmup(CommandSender sender, String command) {
        CooldownState state = this.sessions.getSession(CooldownState.class, sender);
        Map<String, WarmupInfo> map = state.warmupCommands;
        synchronized (map) {
            Map<String, Integer> storedTimes = this.config.registeredActions.get(CooldownsComponent.firstWord(command));
            if (storedTimes == null) {
                return true;
            }
            Integer requiredWarmupTime = storedTimes.get("warmup");
            if (requiredWarmupTime == null || CommandBook.inst().hasPermission(sender, "commandbook.warmup.override." + CooldownsComponent.firstWord(command))) {
                return true;
            }
            WarmupInfo warmupInfo = state.warmupCommands.get(CooldownsComponent.firstWord(command));
            if (warmupInfo == null) {
                warmupInfo = new WarmupInfo(command);
                state.warmupCommands.put(command, warmupInfo);
                sender.sendMessage(ChatColor.YELLOW + "Warmup started for command '" + CooldownsComponent.firstWord(command) + "', time remaining: " + CooldownsComponent.formatTime(requiredWarmupTime, TimeUnit.SECONDS) + " seconds");
                return false;
            }
            if (!command.equals(warmupInfo.fullCommand)) {
                sender.sendMessage(ChatColor.RED + "You are trying to use the command '" + command + "', which already has a warmup in progress. Type /warmup cancel " + CooldownsComponent.firstWord(command) + " to cancel the existing warmup");
            }
            return false;
        }
    }

    private abstract class SubCommands<CommandType> {
        private SubCommands() {
        }

        public abstract String getTypeName();

        public abstract PaginatedResult<CommandType> getListOutput();

        public abstract Collection<CommandType> getActive(CommandSender var1);

        public abstract boolean remove(CommandSender var1, String var2);
    }

    public class WarmupCommands
    extends SubCommands<WarmupInfo> {
        @Command(aliases={"list", "ls"}, desc="List active command limitations", usage="[-p page] [player]", flags="p:", min=0, max=1)
        public void list(CommandContext args, CommandSender sender) throws CommandException {
            CommandSender target = args.argsLength() == 0 ? sender : InputUtil.PlayerParser.matchPlayerOrConsole(sender, args.getString(0));
            this.getListOutput().display(sender, this.getActive(target), args.getFlagInteger('p', 1));
        }

        @Command(aliases={"cancel", "c"}, desc="Cancel a command limitation", usage="<cmd>", min=1)
        public void cancel(CommandContext args, CommandSender sender) throws CommandException {
            String item = args.getJoinedStrings(0);
            if (!this.remove(sender, item)) {
                throw new CommandException("No " + this.getTypeName() + " for input " + item);
            }
            sender.sendMessage(ChatColor.YELLOW + CooldownsComponent.titleCase(this.getTypeName()) + " for command '" + item + "' removed.");
        }

        @Override
        public String getTypeName() {
            return "warmup";
        }

        @Override
        public PaginatedResult<WarmupInfo> getListOutput() {
            return new PaginatedResult<WarmupInfo>("Command - Remaining time"){

                @Override
                public String format(WarmupInfo entry) {
                    Map<String, Integer> storedTimes = ((CooldownsComponent)CooldownsComponent.this).config.registeredActions.get(CooldownsComponent.firstWord(entry.fullCommand));
                    if (storedTimes == null) {
                        return "Invalid warmup: " + entry.fullCommand;
                    }
                    Integer requiredWarmupTime = storedTimes.get("warmup");
                    if (requiredWarmupTime == null) {
                        return "Invalid warmup: " + entry.fullCommand;
                    }
                    return "/" + entry.fullCommand + " - " + CooldownsComponent.formatTime(requiredWarmupTime - entry.remainingTime, TimeUnit.SECONDS);
                }
            };
        }

        @Override
        public Collection<WarmupInfo> getActive(CommandSender sender) {
            return ((CooldownsComponent)CooldownsComponent.this).sessions.getSession(CooldownState.class, (CommandSender)sender).warmupCommands.values();
        }

        @Override
        public boolean remove(CommandSender sender, String name) {
            return ((CooldownsComponent)CooldownsComponent.this).sessions.getSession(CooldownState.class, (CommandSender)sender).warmupCommands.remove(name.toLowerCase()) != null;
        }
    }

    public class CooldownCommands
    extends SubCommands<Map.Entry<String, Integer>> {
        @Command(aliases={"list", "ls"}, desc="List active command limitations", usage="[-p page] [player]", flags="p:", min=0, max=1)
        public void list(CommandContext args, CommandSender sender) throws CommandException {
            CommandSender target = args.argsLength() == 0 ? sender : InputUtil.PlayerParser.matchPlayerOrConsole(sender, args.getString(0));
            this.getListOutput().display(sender, this.getActive(target), args.getFlagInteger('p', 1));
        }

        @Command(aliases={"cancel", "c"}, desc="Cancel a command limitation", usage="<cmd>", min=1)
        public void cancel(CommandContext args, CommandSender sender) throws CommandException {
            String item = args.getJoinedStrings(0);
            if (!this.remove(sender, item)) {
                throw new CommandException("No " + this.getTypeName() + " for input " + item);
            }
            sender.sendMessage(ChatColor.YELLOW + CooldownsComponent.titleCase(this.getTypeName()) + " for command '" + item + "' removed.");
        }

        @Override
        public String getTypeName() {
            return "cooldown";
        }

        @Override
        public PaginatedResult<Map.Entry<String, Integer>> getListOutput() {
            return new PaginatedResult<Map.Entry<String, Integer>>("Command - Time remaining"){

                @Override
                public String format(Map.Entry<String, Integer> entry) {
                    Map<String, Integer> storedTimes = ((CooldownsComponent)CooldownsComponent.this).config.registeredActions.get(entry.getKey());
                    if (storedTimes == null) {
                        return "Invalid cooldown: " + entry.getKey();
                    }
                    Integer requiredCooldownTime = storedTimes.get("cooldown");
                    if (requiredCooldownTime == null) {
                        return "Invalid cooldown: " + entry.getKey();
                    }
                    return entry.getKey() + " - " + CooldownsComponent.formatTime(requiredCooldownTime - entry.getValue(), TimeUnit.SECONDS);
                }
            };
        }

        @Override
        public Collection<Map.Entry<String, Integer>> getActive(CommandSender sender) {
            return ((CooldownsComponent)CooldownsComponent.this).sessions.getSession(CooldownState.class, (CommandSender)sender).cooldownCommands.entrySet();
        }

        @Override
        public boolean remove(CommandSender sender, String name) {
            return ((CooldownsComponent)CooldownsComponent.this).sessions.getSession(CooldownState.class, (CommandSender)sender).cooldownCommands.remove(name.toLowerCase()) != null;
        }
    }

    public class Commands {
        @Command(aliases={"warmup", "warmups"}, desc="Provides information about command warmups")
        @NestedCommand(value={WarmupCommands.class})
        public void warmup() {
        }

        @Command(aliases={"cooldown", "cooldowns"}, desc="Provides information about command cooldowns")
        @NestedCommand(value={CooldownCommands.class})
        public void cooldown() {
        }
    }

    private static class CooldownState
    extends PersistentSession {
        public static final long MAX_AGE = TimeUnit.MINUTES.toMillis(30L);
        public final Map<String, WarmupInfo> warmupCommands = new ConcurrentHashMap<String, WarmupInfo>();
        @Setting(value="cooldown-commands")
        public final Map<String, Integer> cooldownCommands = new ConcurrentHashMap<String, Integer>();

        protected CooldownState() {
            super(MAX_AGE);
        }
    }

    private static class WarmupInfo {
        public final String fullCommand;
        public int remainingTime;

        public WarmupInfo(String fullCommand) {
            this.fullCommand = fullCommand;
        }
    }

    private static class LocalConfiguration
    extends ConfigurationBase {
        @Setting(value="commands")
        public Map<String, Map<String, Integer>> registeredActions = this.createDefaultStructure();

        private LocalConfiguration() {
        }

        public Map<String, Map<String, Integer>> createDefaultStructure() {
            HashMap<String, Map<String, Integer>> result = new HashMap<String, Map<String, Integer>>();
            NestUtil.getNestedMap(result, "command-with-warmup").put("warmup", 50);
            NestUtil.getNestedMap(result, "command-with-cooldown").put("cooldown", 50);
            NestUtil.getNestedMap(result, "command-with-warmup-and-cooldown").put("cooldown", 50);
            NestUtil.getNestedMap(result, "command-with-warmup-and-cooldown").put("warmup", 50);
            return result;
        }
    }
}

