/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook;

import com.sk89q.bukkit.util.CommandsManagerRegistration;
import com.sk89q.commandbook.commands.CommandBookCommands;
import com.sk89q.commandbook.config.LegacyCommandBookConfigurationMigrator;
import com.sk89q.commandbook.session.SessionComponent;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissionsException;
import com.sk89q.minecraft.util.commands.CommandUsageException;
import com.sk89q.minecraft.util.commands.CommandsManager;
import com.sk89q.minecraft.util.commands.MissingNestedCommandException;
import com.sk89q.minecraft.util.commands.WrappedCommandException;
import com.sk89q.util.yaml.YAMLFormat;
import com.sk89q.util.yaml.YAMLNode;
import com.sk89q.util.yaml.YAMLProcessor;
import com.zachsthings.libcomponents.AbstractComponent;
import com.zachsthings.libcomponents.AnnotationHandler;
import com.zachsthings.libcomponents.InjectComponent;
import com.zachsthings.libcomponents.InjectComponentAnnotationHandler;
import com.zachsthings.libcomponents.bukkit.BasePlugin;
import com.zachsthings.libcomponents.bukkit.DefaultsFileYAMLProcessor;
import com.zachsthings.libcomponents.bukkit.YAMLNodeConfigurationNode;
import com.zachsthings.libcomponents.bukkit.YAMLProcessorConfigurationFile;
import com.zachsthings.libcomponents.config.ConfigurationFile;
import com.zachsthings.libcomponents.config.ConfigurationNode;
import com.zachsthings.libcomponents.loader.ClassLoaderComponentLoader;
import com.zachsthings.libcomponents.loader.ComponentLoader;
import com.zachsthings.libcomponents.loader.ConfigListedComponentLoader;
import com.zachsthings.libcomponents.loader.JarFilesComponentLoader;
import com.zachsthings.libcomponents.loader.StaticComponentLoader;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.yaml.snakeyaml.error.YAMLException;

public final class CommandBook
extends BasePlugin {
    private static CommandBook instance;
    private CommandsManager<CommandSender> commands;
    private Map<String, Integer> itemNames;
    public boolean broadcastChanges;
    public boolean useDisplayNames;
    public boolean lookupWithDisplayNames;
    public boolean crappyWrapperCompat;

    public CommandBook() {
        instance = this;
    }

    public static CommandBook inst() {
        return instance;
    }

    public static Logger logger() {
        return CommandBook.inst().getLogger();
    }

    public static void registerEvents(Listener listener) {
        CommandBook.server().getPluginManager().registerEvents(listener, (Plugin)CommandBook.inst());
    }

    public void onEnable() {
        super.onEnable();
        final CommandBook plugin = this;
        this.commands = new CommandsManager<CommandSender>(){

            public boolean hasPermission(CommandSender player, String perm) {
                return plugin.hasPermission(player, perm);
            }
        };
        final CommandsManagerRegistration cmdRegister = new CommandsManagerRegistration((Plugin)this, this.commands);
        if (this.lowPriorityCommandRegistration) {
            this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, new Runnable(){

                @Override
                public void run() {
                    cmdRegister.register(CommandBookCommands.CommandBookParentCommand.class);
                }
            }, 1L);
        } else {
            cmdRegister.register(CommandBookCommands.CommandBookParentCommand.class);
        }
    }

    public void registerComponentLoaders() {
        File classesDir;
        File configDir = new File(this.getDataFolder(), "config/");
        this.componentManager.addComponentLoader((ComponentLoader)new StaticComponentLoader(this.getLogger(), configDir, new AbstractComponent[]{new SessionComponent()}){

            public ConfigurationFile createConfigurationNode(File file) {
                return new YAMLProcessorConfigurationFile(new YAMLProcessor(file, true, YAMLFormat.EXTENDED));
            }
        });
        DefaultsFileYAMLProcessor jarComponentAliases = new DefaultsFileYAMLProcessor("components.yml", false);
        try {
            jarComponentAliases.load();
        }
        catch (IOException e) {
            this.getLogger().severe("Error loading component aliases!");
            e.printStackTrace();
        }
        catch (YAMLException e) {
            this.getLogger().severe("Error loading component aliases!");
            e.printStackTrace();
        }
        this.componentManager.addComponentLoader((ComponentLoader)new ConfigListedComponentLoader(this.getLogger(), (ConfigurationNode)new YAMLNodeConfigurationNode((YAMLNode)this.config), (ConfigurationNode)new YAMLNodeConfigurationNode((YAMLNode)jarComponentAliases), configDir));
        for (String dir : this.config.getStringList("component-class-dirs", Arrays.asList("component-classes"))) {
            classesDir = new File(this.getDataFolder(), dir);
            if (!classesDir.exists() || !classesDir.isDirectory()) {
                classesDir.mkdirs();
            }
            this.componentManager.addComponentLoader((ComponentLoader)new ClassLoaderComponentLoader(this.getLogger(), classesDir, configDir){

                public ConfigurationFile createConfigurationNode(File file) {
                    return new YAMLProcessorConfigurationFile(new YAMLProcessor(file, true, YAMLFormat.EXTENDED));
                }
            });
        }
        for (String dir : this.config.getStringList("component-jar-dirs", Arrays.asList("component-jars"))) {
            classesDir = new File(this.getDataFolder(), dir);
            if (!classesDir.exists() || !classesDir.isDirectory()) {
                classesDir.mkdirs();
            }
            this.componentManager.addComponentLoader((ComponentLoader)new JarFilesComponentLoader(this.getLogger(), classesDir, configDir){

                public ConfigurationFile createConfigurationNode(File file) {
                    return new YAMLProcessorConfigurationFile(new YAMLProcessor(file, true, YAMLFormat.EXTENDED));
                }
            });
        }
        this.componentManager.registerAnnotationHandler(InjectComponent.class, (AnnotationHandler)new InjectComponentAnnotationHandler(this.componentManager));
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        try {
            this.commands.execute(cmd.getName(), args, (Object)sender, new Object[]{sender});
        }
        catch (CommandPermissionsException e) {
            sender.sendMessage(ChatColor.RED + "You don't have permission.");
        }
        catch (MissingNestedCommandException e) {
            sender.sendMessage(ChatColor.RED + e.getUsage());
        }
        catch (CommandUsageException e) {
            sender.sendMessage(ChatColor.RED + e.getMessage());
            sender.sendMessage(ChatColor.RED + e.getUsage());
        }
        catch (WrappedCommandException e) {
            if (e.getCause() instanceof NumberFormatException) {
                sender.sendMessage(ChatColor.RED + "Number expected, string received instead.");
            } else {
                sender.sendMessage(ChatColor.RED + "An error has occurred. See console.");
                e.printStackTrace();
            }
        }
        catch (CommandException e) {
            sender.sendMessage(ChatColor.RED + e.getMessage());
        }
        return true;
    }

    public YAMLProcessor createConfiguration() {
        File configFile = new File(this.getDataFolder(), "config.yml");
        YAMLProcessor config = new YAMLProcessor(configFile, true, YAMLFormat.EXTENDED);
        DefaultsFileYAMLProcessor comments = new DefaultsFileYAMLProcessor("config-comments.yml", false);
        try {
            if (!configFile.exists()) {
                configFile.getParentFile().mkdirs();
                configFile.createNewFile();
            }
            config.load();
            comments.load();
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Error loading configuration: ", e);
        }
        for (Map.Entry e : comments.getMap().entrySet()) {
            if (e.getValue() == null) continue;
            config.setComment((String)e.getKey(), e.getValue().toString());
        }
        String result = new LegacyCommandBookConfigurationMigrator(configFile, config).migrate();
        if (result != null) {
            CommandBook.logger().severe("Error migrating CommandBook configuration: " + result);
        }
        return config;
    }

    public void populateConfiguration(YAMLProcessor config) {
        this.loadItemList(config);
        this.useDisplayNames = config.getBoolean("use-display-names", true);
        this.lookupWithDisplayNames = config.getBoolean("lookup-with-display-names", true);
        this.broadcastChanges = config.getBoolean("broadcast-changes", true);
        this.crappyWrapperCompat = config.getBoolean("crappy-wrapper-compat", true);
        if (this.crappyWrapperCompat) {
            this.getLogger().info("Maximum wrapper compatibility is enabled. Some features have been disabled to be compatible with poorly written server wrappers.");
        }
    }

    protected void loadItemList(YAMLProcessor config) {
        Object itemNamesTemp = config.getProperty("item-names");
        if (itemNamesTemp != null && itemNamesTemp instanceof Map) {
            this.itemNames = new HashMap<String, Integer>();
            try {
                Map temp = (Map)itemNamesTemp;
                for (Map.Entry entry : temp.entrySet()) {
                    String name = entry.getKey().toString().toLowerCase();
                    if (!(entry.getValue() instanceof Integer)) continue;
                    this.itemNames.put(name, (Integer)entry.getValue());
                }
            }
            catch (ClassCastException classCastException) {}
        } else {
            this.itemNames = new HashMap<String, Integer>();
        }
    }

    public Map<String, Integer> getItemNames() {
        return Collections.unmodifiableMap(this.itemNames);
    }
}

