/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook.util.item;

import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.blocks.BaseItem;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.input.ParserContext;
import java.util.Random;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ItemUtil {
    public static BaseItem getItem(String name) {
        try {
            return ItemUtil.getCommandItem(name);
        }
        catch (CommandException e) {
            return null;
        }
    }

    public static BaseItem getCommandItem(String name) throws CommandException {
        try {
            return (BaseItem)WorldEdit.getInstance().getItemFactory().parseFromInput(name, new ParserContext());
        }
        catch (InputParseException e) {
            throw new CommandException(e.getMessage());
        }
    }

    public static void expandStack(ItemStack item, boolean infinite, boolean overrideStackSize) {
        int stackSize;
        if (item == null || item.getAmount() == 0 || item.getType() == Material.AIR) {
            return;
        }
        int n = stackSize = overrideStackSize ? 64 : item.getType().getMaxStackSize();
        if (item.getType().getMaxStackSize() == 1) {
            return;
        }
        if (infinite) {
            item.setAmount(-1);
        } else if (item.getAmount() < stackSize) {
            item.setAmount(stackSize);
        }
    }

    public static DyeColor matchDyeColor(String filter) throws CommandException {
        if (filter.equalsIgnoreCase("random")) {
            DyeColor[] values = DyeColor.values();
            return values[new Random().nextInt(values.length)];
        }
        try {
            return DyeColor.valueOf((String)filter.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CommandException("Unknown dye color name of '" + filter + "'.");
        }
    }
}

