/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook.util.item;

import com.sk89q.commandbook.CommandBook;
import com.sk89q.commandbook.InventoryComponent;
import com.sk89q.commandbook.util.ChatUtil;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.worldedit.blocks.BaseItem;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.registry.ItemMaterial;
import java.util.Collection;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class InventoryUtil {
    public static void giveItem(CommandSender sender, BaseItem item, int amt, Collection<Player> targets, InventoryComponent component, boolean drop, boolean overrideStackSize) throws CommandException {
        boolean infinite = false;
        ItemMaterial material = item.getType().getMaterial();
        int maxStackSize = overrideStackSize ? 64 : material.getMaxStackSize();
        component.checkAllowedItem(sender, item);
        if (amt == 0 || amt < -1) {
            throw new CommandException("Invalid item amount!");
        }
        if (amt == -1) {
            CommandBook.inst().checkPermission(sender, "commandbook.give.infinite");
            infinite = true;
        } else if (overrideStackSize) {
            CommandBook.inst().checkPermission(sender, "commandbook.override.maxstacksize");
        } else if (amt > maxStackSize * 5) {
            if (!CommandBook.inst().hasPermission(sender, "commandbook.give.stacks.unlimited")) {
                throw new CommandException("More than 5 stacks is too excessive.");
            }
        } else if (amt > maxStackSize) {
            CommandBook.inst().checkPermission(sender, "commandbook.give.stacks");
        }
        int targetQuantity = targets.size();
        if (targetQuantity > 1 || !targets.contains(sender)) {
            sender.sendMessage(ChatColor.YELLOW.toString() + targetQuantity + " player(s) have been given " + InventoryUtil.getAmountText(false, infinite, amt) + ' ' + item.getType().toString() + '.');
        }
        BaseItemStack itemStack = new BaseItemStack(item.getType(), item.getNbtData(), 1);
        ItemStack bukkitItemStack = BukkitAdapter.adapt((BaseItemStack)itemStack);
        for (Player player : targets) {
            int left = amt;
            while (left > 0 || infinite) {
                int givenAmt = Math.min(maxStackSize, left);
                bukkitItemStack = bukkitItemStack.clone();
                bukkitItemStack.setAmount(givenAmt);
                left -= givenAmt;
                if (drop) {
                    player.getWorld().dropItemNaturally(player.getLocation(), bukkitItemStack);
                } else {
                    Collection result = player.getInventory().addItem(new ItemStack[]{bukkitItemStack}).values();
                    if (!result.isEmpty()) {
                        for (ItemStack stack : result) {
                            sender.sendMessage(ChatColor.RED + InventoryUtil.getAmountText(true, infinite, left += stack.getAmount()) + ' ' + item.getType().getName() + " could not be given to " + player.getName() + " (their inventory is probably full)!");
                        }
                        break;
                    }
                }
                if (amt != -1) continue;
                break;
            }
            player.updateInventory();
            String amtString = InventoryUtil.getAmountText(false, infinite, amt - left);
            if (player.equals(sender)) {
                player.sendMessage(ChatColor.YELLOW + "You've been given " + amtString + " " + item.getType().getName() + ".");
                continue;
            }
            player.sendMessage(ChatColor.YELLOW + "Given from " + ChatUtil.toColoredName(sender, ChatColor.YELLOW) + ": " + amtString + " " + item.getType().getName() + ".");
        }
    }

    private static String getAmountText(boolean sentenceStart, boolean infinite, int amount) {
        return infinite ? (sentenceStart ? "An" : "an") + " infinite stack of" : String.valueOf(amount);
    }

    public static void takeItem(CommandSender sender, BaseItem item, int amt, Player target) throws CommandException {
        if (amt <= 0) {
            throw new CommandException("Invalid item amount!");
        }
        ItemStack bukkitStack = BukkitAdapter.adapt((BaseItemStack)new BaseItemStack(item.getType(), item.getNbtData(), amt));
        if (target.getInventory().contains(bukkitStack)) {
            target.getInventory().removeItem(new ItemStack[]{bukkitStack});
            target.sendMessage(ChatColor.YELLOW + "Taken from " + ChatUtil.toColoredName(sender, ChatColor.YELLOW) + ": " + amt + " " + item.getType().getName() + ".");
            sender.sendMessage(ChatColor.YELLOW.toString() + amt + " " + item.getType().getName() + " has been taken.");
        } else {
            sender.sendMessage(ChatColor.YELLOW.toString() + target.getName() + " has no " + item.getType().getName() + ".");
        }
    }
}

