/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook.util.entity.player;

import com.sk89q.commandbook.CommandBook;
import com.sk89q.minecraft.util.commands.CommandException;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class PlayerUtil {
    public static Player checkPlayer(CommandSender sender) throws CommandException {
        if (sender instanceof Player) {
            return (Player)sender;
        }
        throw new CommandException("A player context is required. (Specify a world or player if the command supports it.)");
    }

    public static boolean teleportTo(CommandSender sender, Player player, Location target, boolean allowVehicles) {
        target.getChunk().load(true);
        if (player.getVehicle() != null) {
            Entity vehicle = player.getVehicle();
            vehicle.eject();
            boolean success = player.teleport(target);
            if (!allowVehicles) {
                return success;
            }
            String permString = "commandbook.teleport.vehicle." + vehicle.getType().getName().toLowerCase();
            if (CommandBook.inst().hasPermission((CommandSender)player, permString) && (player.getWorld().equals(target.getWorld()) || CommandBook.inst().hasPermission((CommandSender)player, target.getWorld(), permString))) {
                success = success && vehicle.teleport((Entity)player);
                vehicle.setPassenger((Entity)player);
            }
            return success;
        }
        return player.teleport(target);
    }
}

