/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook.util;

import com.sk89q.commandbook.locations.NamedLocation;
import com.sk89q.commandbook.locations.RootLocationManager;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.World;
import com.zachsthings.libcomponents.bukkit.BasePlugin;
import org.bukkit.Location;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class LocationUtil {
    public static Location findFreePosition(Location searchPos) {
        int y;
        org.bukkit.World world = searchPos.getWorld();
        Location loc = searchPos.clone();
        int x = searchPos.getBlockX();
        int origY = y = Math.max(0, searchPos.getBlockY());
        int z = searchPos.getBlockZ();
        int free = 0;
        World weWorld = BukkitAdapter.adapt((org.bukkit.World)world);
        while (y <= world.getMaxHeight() + 2) {
            free = !weWorld.getBlock(BlockVector3.at((int)x, (int)y, (int)z)).getBlockType().getMaterial().isMovementBlocker() ? (int)((byte)(free + 1)) : 0;
            if (free == 2) {
                if (y - 1 != origY) {
                    loc.setX((double)x + 0.5);
                    loc.setY((double)(y - 1));
                    loc.setZ((double)z + 0.5);
                }
                return loc;
            }
            ++y;
        }
        return null;
    }

    public static org.bukkit.World extractWorld(CommandSender sender) {
        if (sender instanceof Player) {
            return ((Player)sender).getWorld();
        }
        if (sender instanceof BlockCommandSender) {
            return ((BlockCommandSender)sender).getBlock().getWorld();
        }
        return (org.bukkit.World)BasePlugin.server().getWorlds().get(0);
    }

    public static Location getManagedLocation(RootLocationManager<NamedLocation> manager, org.bukkit.World world, String id) throws CommandException {
        NamedLocation loc = manager.get(world, id);
        if (loc == null) {
            throw new CommandException("A location by that name could not be found.");
        }
        return loc.getLocation();
    }

    public static double distanceSquared2D(Location a, Location b) {
        return Math.pow(a.getX() - b.getX(), 2.0) + Math.pow(a.getZ() - b.getZ(), 2.0);
    }
}

