/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook.locations;

import com.google.common.collect.Lists;
import com.sk89q.commandbook.CommandBook;
import com.sk89q.commandbook.locations.TeleportSession;
import com.sk89q.commandbook.session.SessionComponent;
import com.sk89q.commandbook.session.SessionFactory;
import com.sk89q.commandbook.util.ChatUtil;
import com.sk89q.commandbook.util.InputUtil;
import com.sk89q.commandbook.util.LocationUtil;
import com.sk89q.commandbook.util.entity.player.PlayerUtil;
import com.sk89q.commandbook.util.entity.player.iterators.TeleportPlayerIterator;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.zachsthings.libcomponents.ComponentInformation;
import com.zachsthings.libcomponents.Depend;
import com.zachsthings.libcomponents.InjectComponent;
import com.zachsthings.libcomponents.bukkit.BasePlugin;
import com.zachsthings.libcomponents.bukkit.BukkitComponent;
import com.zachsthings.libcomponents.config.ConfigurationBase;
import com.zachsthings.libcomponents.config.Setting;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

@ComponentInformation(friendlyName="Teleports", desc="Teleport-related commands")
@Depend(components={SessionComponent.class})
public class TeleportComponent
extends BukkitComponent
implements Listener {
    @InjectComponent
    private SessionComponent sessions;
    private LocalConfiguration config;

    @Override
    public void enable() {
        CommandBook.registerEvents(this);
        this.registerCommands(Commands.class);
        this.config = this.configure(new LocalConfiguration());
        this.sessions.registerSessionFactory(TeleportSession.class, new SessionFactory<TeleportSession>(){

            @Override
            public TeleportSession createSession(CommandSender user) {
                return new TeleportSession(TeleportComponent.this);
            }
        });
    }

    @Override
    public void reload() {
        this.configure(this.config);
    }

    public LocalConfiguration getConfig() {
        return this.config;
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent event) {
        this.sessions.getSession(TeleportSession.class, (CommandSender)event.getPlayer()).rememberLocation(event.getPlayer());
    }

    @EventHandler
    public void onTeleport(PlayerTeleportEvent event) {
        Location loc = event.getTo();
        Player player = event.getPlayer();
        if (event.isCancelled()) {
            return;
        }
        Location ignored = this.sessions.getSession(TeleportSession.class, (CommandSender)player).getIgnoreLocation();
        if (ignored != null) {
            if (ignored.getWorld().equals(loc.getWorld()) && ignored.distanceSquared(loc) <= 2.0) {
                return;
            }
            this.sessions.getSession(TeleportSession.class, (CommandSender)player).setIgnoreLocation(null);
        }
        this.sessions.getSession(TeleportSession.class, (CommandSender)player).rememberLocation(event.getPlayer());
    }

    public class Commands {
        @Command(aliases={"teleport", "tp"}, usage="[target] <destination>", desc="Teleport to a location", flags="s", min=1, max=4)
        @CommandPermissions(value={"commandbook.teleport"})
        public void teleport(CommandContext args, CommandSender sender) throws CommandException {
            List<Object> targets;
            Location loc;
            boolean[] relative = new boolean[]{false, false, false};
            if (args.argsLength() == 1) {
                loc = InputUtil.LocationParser.matchLocation(sender, args.getString(0));
                if (loc.getX() == (double)loc.getBlockX()) {
                    loc.add(0.5, 0.0, 0.0);
                }
                if (loc.getZ() == (double)loc.getBlockZ()) {
                    loc.add(0.0, 0.0, 0.5);
                }
                targets = Lists.newArrayList((Object[])new Player[]{PlayerUtil.checkPlayer(sender)});
            } else if (args.argsLength() == 2) {
                targets = InputUtil.PlayerParser.matchPlayers(sender, args.getString(0));
                loc = InputUtil.LocationParser.matchLocation(sender, args.getString(1));
                if (loc.getX() == (double)loc.getBlockX()) {
                    loc.add(0.5, 0.0, 0.0);
                }
                if (loc.getZ() == (double)loc.getBlockZ()) {
                    loc.add(0.0, 0.0, 0.5);
                }
            } else if (args.argsLength() == 3) {
                targets = Lists.newArrayList((Object[])new Player[]{PlayerUtil.checkPlayer(sender)});
                double x = args.getDouble(0);
                double y = args.getDouble(1);
                double z = args.getDouble(2);
                loc = new Location(PlayerUtil.checkPlayer(sender).getWorld(), x, y, z);
                if (loc.getX() == (double)loc.getBlockX()) {
                    loc.add(0.5, 0.0, 0.0);
                }
                if (loc.getZ() == (double)loc.getBlockZ()) {
                    loc.add(0.0, 0.0, 0.5);
                }
                CommandBook.inst().checkPermission(sender, loc.getWorld(), "commandbook.locations.coords");
            } else if (args.argsLength() == 4) {
                World world;
                targets = InputUtil.PlayerParser.matchPlayers(sender, args.getString(0));
                String xArg = args.getString(1);
                String yArg = args.getString(2);
                String zArg = args.getString(3);
                CommandBook.inst().checkPermission(sender, "commandbook.locations.coords");
                if (xArg.startsWith("~")) {
                    relative[0] = true;
                }
                if (yArg.startsWith("~")) {
                    relative[1] = true;
                }
                if (zArg.startsWith("~")) {
                    relative[2] = true;
                }
                if (relative[0] || relative[1] || relative[2]) {
                    CommandBook.inst().checkPermission(sender, "commandbook.locations.coords.relative");
                }
                double d = Double.parseDouble(xArg.replace("~", ""));
                double y = Double.parseDouble(yArg.replace("~", ""));
                double z = Double.parseDouble(zArg.replace("~", ""));
                try {
                    world = LocationUtil.extractWorld(sender);
                }
                catch (Throwable t) {
                    world = sender instanceof Player ? ((Player)sender).getWorld() : (World)BasePlugin.server().getWorlds().get(0);
                }
                loc = new Location(world, d, y, z);
                if (loc.getX() == (double)loc.getBlockX()) {
                    loc.add(0.5, 0.0, 0.0);
                }
                if (loc.getZ() == (double)loc.getBlockZ()) {
                    loc.add(0.0, 0.0, 0.5);
                }
            } else {
                throw new CommandException("Invalid number of args.");
            }
            boolean hasTeleOtherCurrent = CommandBook.inst().hasPermission(sender, "commandbook.teleport.other");
            boolean hasTeleOtherTo = CommandBook.inst().hasPermission(sender, loc.getWorld(), "commandbook.teleport.other");
            for (Player player : targets) {
                if (player != sender) {
                    if (!loc.getWorld().equals(player.getWorld())) {
                        CommandBook.inst().checkPermission(sender, player.getWorld(), "commandbook.teleport.other");
                    }
                    if (hasTeleOtherCurrent && hasTeleOtherTo) continue;
                    CommandBook.inst().checkPermission(sender, "commandbook.teleport.other");
                    CommandBook.inst().checkPermission(sender, loc.getWorld(), "commandbook.teleport.other");
                    continue;
                }
                CommandBook.inst().checkPermission(sender, loc.getWorld(), "commandbook.teleport");
            }
            new TeleportPlayerIterator(sender, loc, args.hasFlag('s'), relative).iterate(targets);
        }

        @Command(aliases={"call", "tpa"}, usage="<target>", desc="Request a teleport", min=1, max=1)
        @CommandPermissions(value={"commandbook.call"})
        public void requestTeleport(CommandContext args, CommandSender sender) throws CommandException {
            Player player = PlayerUtil.checkPlayer(sender);
            Player target = InputUtil.PlayerParser.matchSinglePlayer(sender, args.getString(0));
            CommandBook.inst().checkPermission(sender, target.getWorld(), "commandbook.call");
            TeleportComponent.this.sessions.getSession(TeleportSession.class, (CommandSender)player).checkLastTeleportRequest(target);
            TeleportComponent.this.sessions.getSession(TeleportSession.class, (CommandSender)target).addBringable(player);
            String senderMessage = ChatUtil.replaceColorMacros(ChatUtil.replaceMacros(sender, ((TeleportComponent)TeleportComponent.this).config.callMessageSender)).replaceAll("%ctarget%", ChatUtil.toColoredName((CommandSender)target, null)).replaceAll("%target%", ChatUtil.toName((CommandSender)target));
            String targetMessage = ChatUtil.replaceColorMacros(ChatUtil.replaceMacros(sender, ((TeleportComponent)TeleportComponent.this).config.callMessageTarget)).replaceAll("%ctarget%", ChatUtil.toColoredName((CommandSender)target, null)).replaceAll("%target%", ChatUtil.toName((CommandSender)target));
            sender.sendMessage(senderMessage);
            target.sendMessage(targetMessage);
        }

        @Command(aliases={"bring", "tphere", "grab", "g"}, usage="<target>", desc="Bring a player to you", min=1, max=1)
        public void bring(CommandContext args, CommandSender sender) throws CommandException {
            Player target;
            Player player;
            block6: {
                player = PlayerUtil.checkPlayer(sender);
                target = null;
                try {
                    target = InputUtil.PlayerParser.matchSinglePlayer(sender, args.getString(0));
                }
                catch (CommandException ex) {
                    if (CommandBook.inst().hasPermission(sender, "commandbook.teleport.other")) break block6;
                    throw ex;
                }
            }
            if (target != null) {
                if (TeleportComponent.this.sessions.getSession(TeleportSession.class, (CommandSender)player).isBringable(target)) {
                    final String senderMessage = ChatUtil.replaceColorMacros(ChatUtil.replaceMacros(sender, ((TeleportComponent)TeleportComponent.this).config.bringMessageSender)).replaceAll("%ctarget%", ChatUtil.toColoredName((CommandSender)target, null)).replaceAll("%target%", target.getName());
                    final String targetMessage = ChatUtil.replaceColorMacros(ChatUtil.replaceMacros(sender, ((TeleportComponent)TeleportComponent.this).config.bringMessageTarget)).replaceAll("%ctarget%", ChatUtil.toColoredName((CommandSender)target, null)).replaceAll("%target%", target.getName());
                    new TeleportPlayerIterator(sender, player.getLocation()){

                        @Override
                        public void onVictim(CommandSender sender, Player player) {
                            player.sendMessage(targetMessage);
                        }

                        @Override
                        public void onInformMany(CommandSender sender, int affected) {
                            sender.sendMessage(senderMessage);
                        }
                    }.iterate(Lists.newArrayList((Object[])new Player[]{target}));
                    return;
                }
                if (!CommandBook.inst().hasPermission(sender, "commandbook.teleport.other")) {
                    throw new CommandException(((TeleportComponent)TeleportComponent.this).config.bringMessageNoPerm);
                }
            }
            Location loc = player.getLocation();
            List<Player> targets = InputUtil.PlayerParser.matchPlayers(sender, args.getString(0));
            for (Player aTarget : targets) {
                if (loc.getWorld().equals(aTarget.getWorld())) continue;
                CommandBook.inst().checkPermission(sender, aTarget.getWorld(), "commandbook.teleport.other");
            }
            new TeleportPlayerIterator(sender, loc).iterate(targets);
        }

        @Command(aliases={"put", "place"}, usage="<target>", desc="Put a player at where you are looking", min=1, max=1)
        @CommandPermissions(value={"commandbook.teleport.other"})
        public void put(CommandContext args, CommandSender sender) throws CommandException {
            List<Player> targets = InputUtil.PlayerParser.matchPlayers(sender, args.getString(0));
            Location loc = InputUtil.LocationParser.matchLocation(sender, "#target");
            for (Player target : targets) {
                if (loc.getWorld().equals(target.getWorld())) continue;
                CommandBook.inst().checkPermission(sender, target.getWorld(), "commandbook.teleport.other");
            }
            new TeleportPlayerIterator(sender, loc).iterate(targets);
        }

        @Command(aliases={"return", "ret"}, usage="[player]", desc="Teleport back to your last location", min=0, max=1)
        @CommandPermissions(value={"commandbook.return"})
        public void ret(CommandContext args, CommandSender sender) throws CommandException {
            Location lastLoc;
            Player player;
            if (args.argsLength() > 0) {
                player = InputUtil.PlayerParser.matchSinglePlayer(sender, args.getString(0));
                if (player != sender) {
                    CommandBook.inst().checkPermission(sender, "commandbook.return.other");
                }
            } else {
                player = PlayerUtil.checkPlayer(sender);
            }
            if ((lastLoc = TeleportComponent.this.sessions.getSession(TeleportSession.class, (CommandSender)player).popLastLocation()) != null) {
                TeleportComponent.this.sessions.getSession(TeleportSession.class, (CommandSender)player).setIgnoreLocation(lastLoc);
                lastLoc.getChunk().load(true);
                new TeleportPlayerIterator(sender, lastLoc){

                    @Override
                    public void onCaller(Player player) {
                        this.sender.sendMessage(ChatColor.YELLOW + "You've been returned.");
                    }

                    @Override
                    public void onVictim(CommandSender sender, Player player) {
                        player.sendMessage(ChatColor.YELLOW + "You've been returned by " + ChatUtil.toColoredName(sender, ChatColor.YELLOW) + ".");
                    }

                    @Override
                    public void onInformMany(CommandSender sender, int affected) {
                        sender.sendMessage(ChatColor.YELLOW.toString() + affected + " returned.");
                    }
                }.iterate(Lists.newArrayList((Object[])new Player[]{player}));
            } else {
                sender.sendMessage(ChatColor.RED + "There's no past location in your history.");
            }
        }
    }

    public static class LocalConfiguration
    extends ConfigurationBase {
        @Setting(value="call-message.sender")
        public String callMessageSender = "`yTeleport request sent.";
        @Setting(value="call-message.target")
        public String callMessageTarget = "`c**TELEPORT** %cname%`c requests a teleport! Use /bring <name> to accept.";
        @Setting(value="call-message.too-soon")
        public String callMessageTooSoon = "Wait a bit before asking again.";
        @Setting(value="bring-message.sender")
        public String bringMessageSender = "`yPlayer teleported.";
        @Setting(value="bring-message.target")
        public String bringMessageTarget = "`yYour teleport request to %cname%`y was accepted.";
        @Setting(value="bring-message.no-perm")
        public String bringMessageNoPerm = "That person didn't request a teleport (recently) and you don't have permission to teleport anyone.";
    }
}

