/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook.locations;

import com.sk89q.commandbook.CommandBook;
import com.sk89q.commandbook.commands.PaginatedResult;
import com.sk89q.commandbook.locations.FlatFileLocationsManager;
import com.sk89q.commandbook.locations.NamedLocation;
import com.sk89q.commandbook.locations.RootLocationManager;
import com.sk89q.commandbook.util.InputUtil;
import com.sk89q.commandbook.util.entity.player.PlayerUtil;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.zachsthings.libcomponents.TemplateComponent;
import com.zachsthings.libcomponents.bukkit.BukkitComponent;
import com.zachsthings.libcomponents.config.ConfigurationBase;
import com.zachsthings.libcomponents.config.Setting;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;

@TemplateComponent
public abstract class LocationsComponent
extends BukkitComponent {
    private final String name;
    private RootLocationManager<NamedLocation> manager;

    protected LocationsComponent(String name) {
        this.name = name;
    }

    @Override
    public void enable() {
        LocalConfiguration config = this.configure(new LocalConfiguration());
        FlatFileLocationsManager.LocationsFactory warpsFactory = new FlatFileLocationsManager.LocationsFactory(CommandBook.inst().getDataFolder(), this.name + "s");
        this.manager = new RootLocationManager<NamedLocation>(warpsFactory, config.perWorld);
        CommandBook.registerEvents(new WorldListener());
    }

    public RootLocationManager<NamedLocation> getManager() {
        return this.manager;
    }

    public void info(String name, World world, CommandSender sender) throws CommandException {
        NamedLocation loc = this.getManager().get(world, name);
        if (loc == null) {
            throw new CommandException("No " + this.name.toLowerCase() + " by that name could be found in " + world.getName() + ".");
        }
        String worldN = loc.getWorldName();
        if (worldN == null) {
            worldN = ((World)CommandBook.server().getWorlds().get(0)).getName();
        }
        Location l = loc.getLocation();
        int x = l.getBlockX();
        int y = l.getBlockY();
        int z = l.getBlockZ();
        sender.sendMessage(ChatColor.GOLD + this.name + " Information for: " + ChatColor.BLUE + loc.getName().toUpperCase());
        sender.sendMessage(ChatColor.YELLOW + "Owner:");
        sender.sendMessage(ChatColor.YELLOW + " - " + ChatColor.WHITE + loc.getCreatorName());
        sender.sendMessage(ChatColor.YELLOW + "Location: ");
        sender.sendMessage(ChatColor.YELLOW + " - World: " + ChatColor.WHITE + worldN);
        sender.sendMessage(ChatColor.YELLOW + " - X: " + ChatColor.WHITE + x + ChatColor.YELLOW + ", Y: " + ChatColor.WHITE + y + ChatColor.YELLOW + ", Z: " + ChatColor.WHITE + z);
    }

    public void remove(String name, World world, CommandSender sender) throws CommandException {
        NamedLocation loc = this.getManager().get(world, name);
        if (loc == null) {
            throw new CommandException("No " + this.name.toLowerCase() + " by that name could be found in " + world.getName() + ".");
        }
        if (!(sender instanceof Player) || !((Player)sender).getUniqueId().equals(loc.getCreatorID())) {
            CommandBook.inst().checkPermission(sender, "commandbook." + this.name.toLowerCase() + ".remove.other");
        }
        this.getManager().remove(world, name);
        sender.sendMessage(ChatColor.YELLOW + this.name + ": " + name.toUpperCase() + " removed.");
    }

    public void list(CommandContext args, CommandSender sender) throws CommandException {
        World world = null;
        if (this.getManager().isPerWorld() && (world = args.hasFlag('w') ? InputUtil.LocationParser.matchWorld(sender, args.getFlag('w')) : PlayerUtil.checkPlayer(sender).getWorld()) == null) {
            throw new CommandException("Error finding world to use!");
        }
        this.getListResult().display(sender, this.getManager().getLocations(world), args.getInteger(0, 1));
    }

    public abstract PaginatedResult<NamedLocation> getListResult();

    private class WorldListener
    implements Listener {
        private WorldListener() {
        }

        @EventHandler
        public void loadWorld(WorldLoadEvent event) {
            LocationsComponent.this.manager.updateWorlds(event.getWorld());
        }

        @EventHandler
        public void unloadWorld(WorldUnloadEvent event) {
            LocationsComponent.this.manager.updateWorlds(event.getWorld());
        }
    }

    private static class LocalConfiguration
    extends ConfigurationBase {
        @Setting(value="per-world")
        public boolean perWorld;

        private LocalConfiguration() {
        }
    }
}

