/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook.jinglenote;

import com.sk89q.commandbook.enginehub.jinglenote.JingleNotePlayer;
import com.sk89q.commandbook.enginehub.jinglenote.bukkit.BukkitJingleNotePlayer;
import com.sk89q.commandbook.enginehub.jinglenote.sequencer.JingleSequencer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;

public class JingleNoteManager {
    protected final Map<UUID, JingleNotePlayer> instances = new HashMap<UUID, JingleNotePlayer>();

    public void play(Player player, JingleSequencer sequencer) {
        UUID playerID = player.getUniqueId();
        if (this.instances.containsKey(playerID)) {
            JingleNotePlayer existing = this.instances.get(playerID);
            existing.stop();
            this.instances.remove(playerID);
        }
        BukkitJingleNotePlayer notePlayer = new BukkitJingleNotePlayer(player, sequencer);
        Thread thread = new Thread(notePlayer::play);
        thread.setDaemon(true);
        thread.setPriority(10);
        thread.setName("JingleNotePlayer for " + playerID);
        thread.start();
        this.instances.put(playerID, notePlayer);
    }

    public boolean stop(UUID playerID) {
        if (this.instances.containsKey(playerID)) {
            JingleNotePlayer existing = this.instances.get(playerID);
            existing.stop();
            this.instances.remove(playerID);
            return true;
        }
        return false;
    }

    public boolean stop(Player player) {
        return this.stop(player.getUniqueId());
    }

    public void stopAll() {
        for (JingleNotePlayer notePlayer : this.instances.values()) {
            notePlayer.stop();
        }
        this.instances.clear();
    }
}

