/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook.jinglenote;

import com.google.common.collect.Lists;
import com.sk89q.commandbook.CommandBook;
import com.sk89q.commandbook.enginehub.jinglenote.sequencer.MidiJingleSequencer;
import com.sk89q.commandbook.jinglenote.JingleNoteManager;
import com.sk89q.commandbook.util.InputUtil;
import com.sk89q.commandbook.util.entity.player.PlayerUtil;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.zachsthings.libcomponents.ComponentInformation;
import com.zachsthings.libcomponents.bukkit.BukkitComponent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiUnavailableException;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

@ComponentInformation(friendlyName="JingleNote", desc="MIDI sequencer for note blocks with commands.")
public class JingleNoteComponent
extends BukkitComponent
implements Listener {
    private JingleNoteManager jingleNoteManager;

    @Override
    public void enable() {
        this.jingleNoteManager = new JingleNoteManager();
        this.registerCommands(Commands.class);
        CommandBook.registerEvents(this);
    }

    @Override
    public void disable() {
        this.jingleNoteManager.stopAll();
    }

    public JingleNoteManager getJingleNoteManager() {
        return this.jingleNoteManager;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        try {
            File file = new File(CommandBook.inst().getDataFolder(), "intro.mid");
            if (file.exists()) {
                MidiJingleSequencer sequencer = new MidiJingleSequencer(file, false);
                this.getJingleNoteManager().play(event.getPlayer(), sequencer);
            }
        }
        catch (MidiUnavailableException e) {
            CommandBook.logger().log(Level.WARNING, "Failed to access MIDI: " + e.getMessage());
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException | InvalidMidiDataException e) {
            CommandBook.logger().log(Level.WARNING, "Failed to read intro MIDI file: " + e.getMessage());
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.getJingleNoteManager().stop(event.getPlayer());
    }

    public class Commands {
        @Command(aliases={"intro"}, usage="", desc="Play the introduction song", min=0, max=0)
        @CommandPermissions(value={"commandbook.intro"})
        public void intro(CommandContext args, CommandSender sender) throws CommandException {
            ArrayList targets = args.argsLength() == 0 ? Lists.newArrayList((Object[])new Player[]{PlayerUtil.checkPlayer(sender)}) : InputUtil.PlayerParser.matchPlayers(sender, args.getString(0));
            for (Player target : targets) {
                if (target == sender) continue;
                CommandBook.inst().checkPermission(sender, "commandbook.intro.other");
                break;
            }
            try {
                MidiJingleSequencer sequencer = new MidiJingleSequencer(new File(CommandBook.inst().getDataFolder(), "intro.mid"), false);
                for (Player player : targets) {
                    JingleNoteComponent.this.getJingleNoteManager().play(player, sequencer);
                    player.sendMessage(ChatColor.YELLOW + "Playing intro.midi...");
                }
            }
            catch (MidiUnavailableException e) {
                throw new CommandException("Failed to access MIDI: " + e.getMessage());
            }
            catch (FileNotFoundException e) {
                throw new CommandException("No intro.mid is available.");
            }
            catch (IOException | InvalidMidiDataException e) {
                throw new CommandException("Failed to read intro MIDI file: " + e.getMessage());
            }
        }

        @Command(aliases={"midi", "play"}, usage="[-p player] [midi]", desc="Play a MIDI file", flags="p:", min=0, max=1)
        public void midi(CommandContext args, CommandSender sender) throws CommandException {
            ArrayList targets = args.hasFlag('p') ? InputUtil.PlayerParser.matchPlayers(sender, args.getFlag('p')) : Lists.newArrayList((Object[])new Player[]{PlayerUtil.checkPlayer(sender)});
            for (Player target : targets) {
                if (target == sender) continue;
                CommandBook.inst().checkPermission(sender, "commandbook.midi.other");
                break;
            }
            if (args.argsLength() == 0) {
                for (Player target : targets) {
                    if (!JingleNoteComponent.this.getJingleNoteManager().stop(target)) continue;
                    target.sendMessage(ChatColor.YELLOW + "All music stopped.");
                }
                return;
            }
            CommandBook.inst().checkPermission(sender, "commandbook.midi");
            String filename = args.getString(0);
            if (!filename.matches("^[A-Za-z0-9 \\-_\\.~\\[\\]\\(\\$),]+$")) {
                throw new CommandException("Invalid filename specified!");
            }
            File[] trialPaths = new File[]{new File(CommandBook.inst().getDataFolder(), "midi/" + filename), new File(CommandBook.inst().getDataFolder(), "midi/" + filename + ".mid"), new File(CommandBook.inst().getDataFolder(), "midi/" + filename + ".midi"), new File("midi", filename), new File("midi", filename + ".mid"), new File("midi", filename + ".midi")};
            File file = null;
            for (File f : trialPaths) {
                if (!f.exists()) continue;
                file = f;
                break;
            }
            if (file == null) {
                throw new CommandException("The specified MIDI file was not found.");
            }
            try {
                MidiJingleSequencer sequencer = new MidiJingleSequencer(file, false);
                for (Player player : targets) {
                    JingleNoteComponent.this.getJingleNoteManager().play(player, sequencer);
                    player.sendMessage(ChatColor.YELLOW + "Playing " + file.getName() + "... Use '/midi' to stop.");
                }
            }
            catch (MidiUnavailableException e) {
                throw new CommandException("Failed to access MIDI: " + e.getMessage());
            }
            catch (FileNotFoundException e) {
                throw new CommandException("The specified MIDI file was not found.");
            }
            catch (IOException | InvalidMidiDataException e) {
                throw new CommandException("Failed to read intro MIDI file: " + e.getMessage());
            }
        }
    }
}

