/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook.enginehub.jinglenote.sequencer;

import com.sk89q.commandbook.enginehub.jinglenote.Instrument;
import com.sk89q.commandbook.enginehub.jinglenote.JingleNotePlayer;
import com.sk89q.commandbook.enginehub.jinglenote.Note;
import com.sk89q.commandbook.enginehub.jinglenote.sequencer.JingleSequencer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;

public class MidiJingleSequencer
implements JingleSequencer {
    private static final byte[] instruments = new byte[]{0, 0, 0, 0, 0, 0, 0, 11, 6, 6, 6, 6, 9, 9, 15, 11, 10, 5, 5, 10, 10, 10, 10, 10, 5, 5, 5, 5, 5, 5, 5, 5, 1, 1, 1, 1, 1, 1, 1, 1, 0, 10, 10, 1, 0, 0, 0, 4, 0, 0, 0, 0, 8, 8, 8, 12, 8, 14, 14, 14, 14, 14, 8, 8, 8, 8, 8, 14, 14, 8, 8, 8, 8, 8, 8, 8, 14, 8, 8, 8, 8, 14, 8, 8, 5, 8, 12, 1, 1, 0, 0, 8, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 12, 11, 11, 3, 3, 3, 14, 10, 6, 6, 3, 3, 2, 2, 2, 6, 5, 1, 1, 1, 13, 13, 2, 4, 7};
    private static final byte[] percussion = new byte[]{9, 6, 4, 4, 3, 2, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 7, 2, 7, 7, 6, 3, 7, 6, 7, 3, 7, 2, 2, 3, 3, 3, 2, 2, 6, 6, 2, 2, 0, 0, 3, 3, 3, 3, 3, 3, 5, 5, 15, 15};
    private Sequencer sequencer;
    private boolean running = false;
    private boolean playedBefore = false;
    private List<JingleNotePlayer> players = new ArrayList<JingleNotePlayer>();

    public MidiJingleSequencer(File midiFile, boolean loop) throws MidiUnavailableException, InvalidMidiDataException, IOException {
        try {
            this.sequencer = MidiSystem.getSequencer(false);
            this.sequencer.open();
            Sequence seq = MidiSystem.getSequence(midiFile);
            this.sequencer.setSequence(seq);
            if (loop) {
                this.sequencer.setLoopCount(-1);
            }
        }
        catch (IOException | InvalidMidiDataException | MidiUnavailableException e) {
            this.stop();
            throw e;
        }
    }

    @Override
    public void play() {
        final HashMap patches = new HashMap();
        try {
            if (this.sequencer == null || this.sequencer.getSequence() == null) {
                return;
            }
            if (!this.sequencer.isOpen()) {
                this.sequencer.open();
            }
            this.sequencer.getTransmitter().setReceiver(new Receiver(){

                @Override
                public void send(MidiMessage message, long timeStamp) {
                    block6: {
                        block5: {
                            if (MidiJingleSequencer.this.players.isEmpty()) {
                                MidiJingleSequencer.this.running = false;
                                return;
                            }
                            if ((message.getStatus() & 0xF0) != 192) break block5;
                            ShortMessage msg = (ShortMessage)message;
                            int chan = msg.getChannel();
                            int patch = msg.getData1();
                            patches.put(chan, patch);
                            break block6;
                        }
                        if ((message.getStatus() & 0xF0) != 144) break block6;
                        ShortMessage msg = (ShortMessage)message;
                        int chan = msg.getChannel();
                        int n = msg.getData1();
                        if (chan == 9) {
                            for (JingleNotePlayer player : MidiJingleSequencer.this.players) {
                                player.playNote(new Note(Instrument.fromByte(MidiJingleSequencer.toMCPercussion((Integer)patches.get(chan))), MidiJingleSequencer.toMCNote(n), 10.0f * ((float)msg.getData2() / 127.0f)));
                            }
                        } else {
                            for (JingleNotePlayer player : MidiJingleSequencer.this.players) {
                                player.playNote(new Note(Instrument.fromByte(MidiJingleSequencer.toMCInstrument((Integer)patches.get(chan))), MidiJingleSequencer.toMCNote(n), 10.0f * ((float)msg.getData2() / 127.0f)));
                            }
                        }
                    }
                }

                @Override
                public void close() {
                    MidiJingleSequencer.this.running = false;
                }
            });
            try {
                if (!this.sequencer.isOpen()) {
                    throw new IllegalArgumentException("Sequencer is not open!");
                }
                this.sequencer.start();
                this.running = true;
                this.playedBefore = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (MidiUnavailableException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stop() {
        if (!this.running) {
            return;
        }
        this.players.clear();
        if (this.sequencer != null) {
            try {
                if (this.sequencer.isRunning()) {
                    this.sequencer.stop();
                }
                if (this.sequencer.isOpen()) {
                    this.sequencer.close();
                }
                this.sequencer = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.running = false;
    }

    private static byte toMCNote(int n) {
        if (n < 54) {
            return (byte)((n - 6) % 12);
        }
        if (n > 78) {
            return (byte)((n - 6) % 12 + 12);
        }
        return (byte)(n - 54);
    }

    private static byte toMCInstrument(Integer patch) {
        if (patch == null) {
            return 0;
        }
        if (patch < 0 || patch >= instruments.length) {
            return 0;
        }
        return instruments[patch];
    }

    private static byte toMCPercussion(Integer patch) {
        if (patch == null) {
            return 0;
        }
        int i = patch - 33;
        if (i < 0 || i >= percussion.length) {
            return 1;
        }
        return percussion[i];
    }

    @Override
    public boolean isPlaying() {
        return this.running && this.sequencer != null;
    }

    @Override
    public boolean isActive() {
        return !this.playedBefore || this.isPlaying();
    }

    @Override
    public void removePlayer(JingleNotePlayer player) {
        this.players.remove(player);
        if (this.players.isEmpty()) {
            this.stop();
        }
    }

    @Override
    public void addPlayer(JingleNotePlayer player) {
        this.players.add(player);
        if (!this.playedBefore) {
            this.play();
        }
    }

    @Override
    public Collection<JingleNotePlayer> getPlayers() {
        return this.players;
    }
}

