/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook.enginehub.jinglenote.bukkit;

import com.sk89q.commandbook.enginehub.jinglenote.Instrument;
import com.sk89q.commandbook.enginehub.jinglenote.JingleNotePlayer;
import com.sk89q.commandbook.enginehub.jinglenote.Note;
import com.sk89q.commandbook.enginehub.jinglenote.sequencer.JingleSequencer;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Player;

public class BukkitJingleNotePlayer
extends JingleNotePlayer {
    private final Player player;

    public BukkitJingleNotePlayer(Player player, JingleSequencer sequencer) {
        super(sequencer);
        this.player = player;
    }

    @Override
    public void playNote(Note note) {
        if (!this.isActive()) {
            return;
        }
        this.player.playSound(this.player.getLocation(), BukkitJingleNotePlayer.toSound(note.getInstrument()), SoundCategory.RECORDS, note.getVelocity(), note.getPitch());
    }

    @Override
    public boolean isActive() {
        return super.isActive() && this.player.isValid() && this.player.isOnline();
    }

    private static Sound toSound(Instrument instrument) {
        switch (instrument) {
            case BASS: {
                return Sound.BLOCK_NOTE_BLOCK_BASS;
            }
            case SNARE: {
                return Sound.BLOCK_NOTE_BLOCK_SNARE;
            }
            case HAT: {
                return Sound.BLOCK_NOTE_BLOCK_HAT;
            }
            case BANJO: {
                return Sound.BLOCK_NOTE_BLOCK_BANJO;
            }
            case BASEDRUM: {
                return Sound.BLOCK_NOTE_BLOCK_BASEDRUM;
            }
            case BELL: {
                return Sound.BLOCK_NOTE_BLOCK_BELL;
            }
            case BIT: {
                return Sound.BLOCK_NOTE_BLOCK_BIT;
            }
            case CHIME: {
                return Sound.BLOCK_NOTE_BLOCK_CHIME;
            }
            case COW_BELL: {
                return Sound.BLOCK_NOTE_BLOCK_COW_BELL;
            }
            case DIDGERIDOO: {
                return Sound.BLOCK_NOTE_BLOCK_DIDGERIDOO;
            }
            case FLUTE: {
                return Sound.BLOCK_NOTE_BLOCK_FLUTE;
            }
            case XYLOPHONE: {
                return Sound.BLOCK_NOTE_BLOCK_XYLOPHONE;
            }
            case IRON_XYLOPHONE: {
                return Sound.BLOCK_NOTE_BLOCK_IRON_XYLOPHONE;
            }
            case PLING: {
                return Sound.BLOCK_NOTE_BLOCK_PLING;
            }
            case GUITAR: {
                return Sound.BLOCK_NOTE_BLOCK_GUITAR;
            }
        }
        return Sound.BLOCK_NOTE_BLOCK_HARP;
    }
}

