/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook;

import com.google.common.collect.Lists;
import com.sk89q.commandbook.CommandBook;
import com.sk89q.commandbook.session.SessionComponent;
import com.sk89q.commandbook.session.UserSession;
import com.sk89q.commandbook.util.ChatUtil;
import com.sk89q.commandbook.util.InputUtil;
import com.sk89q.commandbook.util.entity.player.PlayerUtil;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.item.ItemTypes;
import com.zachsthings.libcomponents.ComponentInformation;
import com.zachsthings.libcomponents.Depend;
import com.zachsthings.libcomponents.InjectComponent;
import com.zachsthings.libcomponents.bukkit.BukkitComponent;
import com.zachsthings.libcomponents.config.ConfigurationBase;
import com.zachsthings.libcomponents.config.Setting;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

@ComponentInformation(friendlyName="Thor", desc="Thor's hammer and other lightning effects.")
@Depend(components={SessionComponent.class})
public class ThorComponent
extends BukkitComponent
implements Listener {
    @InjectComponent
    private SessionComponent sessions;
    private LocalConfiguration config;
    private static final Random random = new Random();

    @Override
    public void enable() {
        this.config = this.configure(new LocalConfiguration());
        CommandBook.registerEvents(this);
        this.registerCommands(Commands.class);
    }

    @Override
    public void reload() {
        super.reload();
        this.configure(this.config);
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (this.sessions.getSession(UserSession.class, (CommandSender)player).hasThor()) {
            if (!this.config.thorItems.contains(BukkitAdapter.adapt((ItemStack)player.getItemInHand()).getType().getId())) {
                return;
            }
            if (event.getAction() == Action.LEFT_CLICK_AIR) {
                Block block = player.getTargetBlock((Set)null, 300);
                if (block != null) {
                    player.getWorld().strikeLightning(block.getLocation());
                }
            } else if (event.getAction() == Action.LEFT_CLICK_BLOCK) {
                Block block = event.getClickedBlock();
                player.getWorld().strikeLightning(block.getLocation());
            }
        }
    }

    public class Commands {
        @Command(aliases={"shock"}, usage="[target]", desc="Shock a player", flags="ksa", min=0, max=1)
        @CommandPermissions(value={"commandbook.shock"})
        public void shock(CommandContext args, CommandSender sender) throws CommandException {
            List<Player> targets = null;
            boolean included = false;
            int count = 0;
            if (args.argsLength() == 0) {
                targets = Lists.newArrayList((Object[])new Player[]{PlayerUtil.checkPlayer(sender)});
            } else if (args.argsLength() == 1) {
                targets = InputUtil.PlayerParser.matchPlayers(sender, args.getString(0));
            }
            for (final Player player : targets) {
                if (player != sender) {
                    CommandBook.inst().checkPermission(sender, "commandbook.shock.other");
                    continue;
                }
                CommandBook.inst().checkPermission(sender, "commandbook.shock");
            }
            for (final Player player : targets) {
                ++count;
                if (args.hasFlag('a')) {
                    final Location origLoc = player.getLocation();
                    for (int i = 0; i < 10; ++i) {
                        CommandBook.server().getScheduler().scheduleSyncDelayedTask((Plugin)CommandBook.inst(), new Runnable(){

                            @Override
                            public void run() {
                                Location loc = origLoc.clone();
                                loc.setX(loc.getX() + random.nextDouble() * 20.0 - 10.0);
                                loc.setZ(loc.getZ() + random.nextDouble() * 20.0 - 10.0);
                                player.getWorld().strikeLightning(loc);
                            }
                        }, (long)Math.max(0, i * 3 + random.nextInt(10) - 5));
                    }
                } else {
                    player.getWorld().strikeLightning(player.getLocation());
                }
                if (args.hasFlag('k')) {
                    player.setHealth(0.0);
                }
                if (args.hasFlag('s')) {
                    if (player.equals(sender)) {
                        player.sendMessage(ChatColor.YELLOW + "Shocked!");
                        included = true;
                        continue;
                    }
                    player.sendMessage(ChatColor.YELLOW + "You've been shocked by " + ChatUtil.toColoredName(sender, ChatColor.YELLOW) + ".");
                    continue;
                }
                if (count < 6) {
                    CommandBook.server().broadcastMessage(ChatColor.YELLOW + ChatUtil.toColoredName(sender, ChatColor.YELLOW) + " shocked " + ChatUtil.toColoredName((CommandSender)player, ChatColor.YELLOW));
                    continue;
                }
                if (count != 6) continue;
                CommandBook.server().broadcastMessage(ChatColor.YELLOW + ChatUtil.toColoredName(sender, ChatColor.YELLOW) + " shocked more people...");
            }
            if (!included && args.hasFlag('s')) {
                sender.sendMessage(ChatColor.YELLOW.toString() + "Players shocked.");
            }
        }

        @Command(aliases={"thor"}, usage="[target]", desc="Give a player Thor power", flags="", min=0, max=1)
        @CommandPermissions(value={"commandbook.thor"})
        public void thor(CommandContext args, CommandSender sender) throws CommandException {
            List<Player> targets = null;
            boolean included = false;
            if (args.argsLength() == 0) {
                targets = Lists.newArrayList((Object[])new Player[]{PlayerUtil.checkPlayer(sender)});
            } else if (args.argsLength() == 1) {
                targets = InputUtil.PlayerParser.matchPlayers(sender, args.getString(0));
            }
            for (Player player : targets) {
                if (player != sender) {
                    CommandBook.inst().checkPermission(sender, "commandbook.thor.other");
                    continue;
                }
                CommandBook.inst().checkPermission(sender, "commandbook.thor");
            }
            for (Player player : targets) {
                ThorComponent.this.sessions.getSession(UserSession.class, (CommandSender)player).setHasThor(true);
                if (player.equals(sender)) {
                    player.sendMessage(ChatColor.YELLOW + "You have been granted the mighty power of Thor's hammer!");
                    included = true;
                    continue;
                }
                player.sendMessage(ChatColor.YELLOW + "You have been granted the might power of Thor's hammer by " + ChatUtil.toColoredName(sender, ChatColor.YELLOW) + ".");
            }
            if (!included && args.hasFlag('s')) {
                sender.sendMessage(ChatColor.YELLOW.toString() + "Players given Thor's hammer.");
            }
        }

        @Command(aliases={"unthor"}, usage="[target]", desc="Revoke a player's Thor power", flags="", min=0, max=1)
        @CommandPermissions(value={"commandbook.thor"})
        public void unthor(CommandContext args, CommandSender sender) throws CommandException {
            List<Player> targets = null;
            boolean included = false;
            if (args.argsLength() == 0) {
                targets = Lists.newArrayList((Object[])new Player[]{PlayerUtil.checkPlayer(sender)});
            } else if (args.argsLength() == 1) {
                targets = InputUtil.PlayerParser.matchPlayers(sender, args.getString(0));
            }
            for (Player player : targets) {
                if (player != sender) {
                    CommandBook.inst().checkPermission(sender, "commandbook.thor.other");
                    continue;
                }
                CommandBook.inst().checkPermission(sender, "commandbook.thor");
            }
            for (Player player : targets) {
                ThorComponent.this.sessions.getSession(UserSession.class, (CommandSender)player).setHasThor(false);
                if (player.equals(sender)) {
                    player.sendMessage(ChatColor.YELLOW + "You've lost Thor's hammer!");
                    included = true;
                    continue;
                }
                player.sendMessage(ChatColor.YELLOW + "Thor's hammer has been revoked from you by " + ChatUtil.toColoredName(sender, ChatColor.YELLOW) + ".");
            }
            if (!included && args.hasFlag('s')) {
                sender.sendMessage(ChatColor.YELLOW.toString() + "Thor's hammer revokved from players.");
            }
        }
    }

    private static class LocalConfiguration
    extends ConfigurationBase {
        @Setting(value="hammer-items")
        public Set<String> thorItems = new HashSet<String>(Arrays.asList(ItemTypes.WOODEN_PICKAXE.getId(), ItemTypes.STONE_PICKAXE.getId(), ItemTypes.IRON_PICKAXE.getId(), ItemTypes.GOLDEN_PICKAXE.getId(), ItemTypes.DIAMOND_PICKAXE.getId()));

        private LocalConfiguration() {
        }
    }
}

