/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook;

import com.sk89q.commandbook.CommandBook;
import com.zachsthings.libcomponents.ComponentInformation;
import com.zachsthings.libcomponents.bukkit.BukkitComponent;
import java.util.regex.Pattern;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLoginEvent;

@ComponentInformation(friendlyName="Name Verification", desc="This component verifies that player names are valid when they join.")
public class NameVerificationComponent
extends BukkitComponent
implements Listener {
    protected static final Pattern namePattern = Pattern.compile("^[a-zA-Z0-9_]{1,16}$");

    @Override
    public void enable() {
        CommandBook.registerEvents(this);
    }

    @EventHandler
    public void onLogin(PlayerLoginEvent event) {
        if (!namePattern.matcher(event.getPlayer().getName()).matches()) {
            CommandBook.logger().info("Name verification: " + event.getPlayer().getName() + " was kicked for having an invalid name (to disable, turn off the name-verification component in CommandBook)");
            event.disallow(PlayerLoginEvent.Result.KICK_OTHER, "Invalid player name detected!");
        }
    }
}

