/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook;

import com.sk89q.commandbook.CommandBook;
import com.sk89q.commandbook.GodComponent;
import com.sk89q.commandbook.session.PersistentSession;
import com.sk89q.commandbook.session.SessionComponent;
import com.sk89q.commandbook.util.LocationUtil;
import com.sk89q.commandbook.util.entity.player.PlayerUtil;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.zachsthings.libcomponents.ComponentInformation;
import com.zachsthings.libcomponents.Depend;
import com.zachsthings.libcomponents.InjectComponent;
import com.zachsthings.libcomponents.bukkit.BukkitComponent;
import com.zachsthings.libcomponents.config.ConfigurationBase;
import com.zachsthings.libcomponents.config.Setting;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;

@ComponentInformation(friendlyName="AFK Checker", desc="AFK Checking and management.")
@Depend(components={GodComponent.class, SessionComponent.class})
public class AFKComponent
extends BukkitComponent
implements Runnable,
Listener {
    private final CommandBook inst = CommandBook.inst();
    private final Logger log = CommandBook.logger();
    private final Server server = CommandBook.server();
    @InjectComponent
    private GodComponent godComp;
    @InjectComponent
    private SessionComponent sessions;
    private LocalConfiguration config;

    @Override
    public void enable() {
        this.config = this.configure(new LocalConfiguration());
        CommandBook.registerEvents(this);
        if (this.config.useMovementEvent) {
            CommandBook.registerEvents(new MovementListener());
        }
        this.registerCommands(Commands.class);
        this.server.getScheduler().runTaskTimer((Plugin)this.inst, (Runnable)this, 20L, 20L);
    }

    @Override
    public void reload() {
        super.reload();
        this.configure(this.config);
    }

    public boolean isAfk(Player player) {
        return this.sessions.getSession(AFKSession.class, (CommandSender)player).isAFK();
    }

    public boolean isAfk(long time) {
        return time != 0L && System.currentTimeMillis() - time >= TimeUnit.MINUTES.toMillis(this.config.afkMinutes);
    }

    public boolean shouldKick(Player player) {
        return this.shouldKick(this.sessions.getSession(AFKSession.class, (CommandSender)player).getLastUpdate());
    }

    public boolean shouldKick(long time) {
        if (this.config.afkKickMinutes < 1) {
            return false;
        }
        double maxP = this.server.getMaxPlayers();
        double curP = this.server.getOnlinePlayers().size();
        double fraction = (maxP - curP + maxP * 0.2) / maxP;
        int duration = (int)Math.max((double)(this.config.afkMinutes + 2), Math.min((double)this.config.afkKickMinutes, (double)this.config.afkKickMinutes * fraction));
        return time != 0L && System.currentTimeMillis() - time >= TimeUnit.MINUTES.toMillis(duration);
    }

    public boolean canIgnoreSleep(Player player) {
        AFKSession session = this.sessions.getSession(AFKSession.class, (CommandSender)player);
        return session.isRequested() && this.canIgnoreSleep(true) || this.isAfk(session.getLastUpdate()) && this.canIgnoreSleep(false);
    }

    public boolean canIgnoreSleep(boolean requested) {
        return !requested && this.config.afkGeneralSleepIgnored || requested && this.config.afkCommandSleepIgnored;
    }

    public boolean canProtect(Player player) {
        AFKSession session = this.sessions.getSession(AFKSession.class, (CommandSender)player);
        return session.isRequested() && this.canProtect(true) || this.isAfk(session.getLastUpdate()) && this.canProtect(false);
    }

    public boolean canProtect(boolean requested) {
        return !requested && this.config.afkGeneralProtection || requested && this.config.afkCommandProtection;
    }

    public void update(Player player) {
        AFKSession session = this.sessions.getSession(AFKSession.class, (CommandSender)player);
        session.setLastUpdate(System.currentTimeMillis());
        session.setIdleStatus(null);
        if (this.godComp != null && session.isProtected() && this.godComp.hasGodMode(player)) {
            this.godComp.disableGodMode(player);
            session.setProtected(false);
        }
    }

    @Override
    public void run() {
        Collection onlinePlayers = this.config.npcCompatibilty ? this.server.getOnlinePlayers() : null;
        for (final AFKSession session : this.sessions.getSessions(AFKSession.class).values()) {
            Player target;
            if (session == null || (target = session.getPlayer()) == null || !session.getPlayer().isValid() || onlinePlayers != null && (target.hasMetadata("NPC") || !onlinePlayers.contains(target))) continue;
            boolean passedTime = this.isAfk(session.getLastUpdate());
            if (session.isRequested() || passedTime) {
                if (this.shouldKick(session.getLastUpdate())) {
                    if (session.isSleepIgnored()) {
                        target.setSleepingIgnored(false);
                        session.setSleepIgnored(false);
                    }
                    this.server.getScheduler().runTaskLater((Plugin)this.inst, new Runnable(){

                        @Override
                        public void run() {
                            target.kickPlayer("Inactivity - " + (System.currentTimeMillis() - session.getLastUpdate()) / 60000L + " Minutes");
                        }
                    }, 1L);
                } else if (!session.isAFK()) {
                    String name = target.getName();
                    session.setLastTabName(target.getPlayerListName());
                    target.setPlayerListName(ChatColor.GRAY + name.substring(0, Math.min(14, name.length())));
                    session.setAFK(true);
                    target.sendMessage(ChatColor.YELLOW + "You are now marked as AFK.");
                }
                if ((this.canIgnoreSleep(session.isRequested()) || passedTime && this.canIgnoreSleep(false)) && !target.isSleepingIgnored()) {
                    target.setSleepingIgnored(true);
                    session.setSleepIgnored(true);
                }
                if (this.godComp == null || !this.canProtect(session.isRequested()) && (!passedTime || !this.canProtect(false)) || this.godComp.hasGodMode(target)) continue;
                this.godComp.enableGodMode(target);
                session.setProtected(true);
                continue;
            }
            if (!session.isAFK()) continue;
            String lastName = session.getLastTabName();
            target.setPlayerListName(lastName == null ? target.getName() : lastName);
            if (session.isSleepIgnored()) {
                target.setSleepingIgnored(false);
                session.setSleepIgnored(false);
            }
            session.setAFK(false);
            target.sendMessage(ChatColor.YELLOW + "You are no longer marked as AFK.");
        }
    }

    @EventHandler
    public void onEntityTargetPlayer(EntityTargetEvent event) {
        if (event.getTarget() instanceof Player && this.canProtect((Player)event.getTarget())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.update(event.getPlayer());
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        this.update(event.getPlayer());
    }

    @EventHandler
    public void onCommand(PlayerCommandPreprocessEvent event) {
        this.update(event.getPlayer());
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        this.update(event.getPlayer());
    }

    @EventHandler
    public void onPlayerFish(PlayerFishEvent event) {
        this.update(event.getPlayer());
    }

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent event) {
        if (event.getPlayer() instanceof Player) {
            this.update((Player)event.getPlayer());
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getWhoClicked() instanceof Player) {
            this.update((Player)event.getWhoClicked());
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getPlayer() instanceof Player) {
            this.update((Player)event.getPlayer());
        }
    }

    @EventHandler
    public void onEntityDamageEntityEvent(EntityDamageByEntityEvent event) {
        if (event.getDamager() instanceof Player) {
            this.update((Player)event.getDamager());
        }
    }

    public static class AFKSession
    extends PersistentSession {
        @Setting(value="idle-status")
        private String idleStatus = "null";
        private String lastTabName;
        private long lastUpdate = 0L;
        private boolean protect = false;
        private boolean sleepIgnored = false;
        private boolean awayFromKeyboard = false;

        protected AFKSession() {
            super(THIRTY_MINUTES);
        }

        public Player getPlayer() {
            CommandSender sender = super.getOwner();
            return sender instanceof Player ? (Player)sender : null;
        }

        public String getIdleStatus() {
            return this.idleStatus.equals("null") ? "" : this.idleStatus;
        }

        public void setIdleStatus(String status) {
            this.idleStatus = status == null ? "null" : status;
        }

        public String getLastTabName() {
            return this.lastTabName;
        }

        public void setLastTabName(String lastTabName) {
            this.lastTabName = lastTabName;
        }

        public boolean isRequested() {
            return !this.idleStatus.equals("null");
        }

        public long getLastUpdate() {
            return this.lastUpdate;
        }

        public void setLastUpdate(long lastUpdate) {
            this.lastUpdate = lastUpdate;
        }

        public boolean isProtected() {
            return this.protect;
        }

        public void setProtected(boolean protect) {
            this.protect = protect;
        }

        public boolean isSleepIgnored() {
            return this.sleepIgnored;
        }

        public void setSleepIgnored(boolean sleepIgnored) {
            this.sleepIgnored = sleepIgnored;
        }

        public boolean isAFK() {
            return this.awayFromKeyboard;
        }

        public void setAFK(boolean awayFromKeyboard) {
            this.awayFromKeyboard = awayFromKeyboard;
        }
    }

    public class MovementListener
    implements Listener {
        @EventHandler
        public void onMoveChange(PlayerMoveEvent event) {
            Player player = event.getPlayer();
            double distanceSQ = LocationUtil.distanceSquared2D(event.getFrom(), event.getTo());
            if (distanceSQ > ((AFKComponent)AFKComponent.this).config.movementThreshold || player.isSneaking() && distanceSQ > ((AFKComponent)AFKComponent.this).config.sneakMovementThreshold) {
                AFKComponent.this.update(player);
            }
        }
    }

    public class Commands {
        @Command(aliases={"afk", "away"}, usage="", desc="Set yourself as away", flags="", min=0, max=-1)
        @CommandPermissions(value={"commandbook.away"})
        public void afk(CommandContext args, CommandSender sender) throws CommandException {
            Player player = PlayerUtil.checkPlayer(sender);
            String status = "";
            if (args.argsLength() > 0 && (status = args.getJoinedStrings(0)).equals("null")) {
                status = "";
            }
            AFKComponent.this.sessions.getSession(AFKSession.class, (CommandSender)player).setIdleStatus(status);
            player.sendMessage(ChatColor.YELLOW + (status.isEmpty() ? "Set as away" : "Set away status to \"" + status + "\"") + ".");
        }
    }

    private static class LocalConfiguration
    extends ConfigurationBase {
        @Setting(value="use-movement-event")
        public boolean useMovementEvent = true;
        @Setting(value="movement-threshold")
        public double movementThreshold = 0.04;
        @Setting(value="sneak-movement-threshold")
        public double sneakMovementThreshold = 0.004;
        @Setting(value="afk-minutes")
        public int afkMinutes = 3;
        @Setting(value="afk-kick-minutes")
        public int afkKickMinutes = 60;
        @Setting(value="afk-general-sleep-ignored")
        public boolean afkGeneralSleepIgnored = true;
        @Setting(value="afk-command-sleep-ignored")
        public boolean afkCommandSleepIgnored = false;
        @Setting(value="afk-general-protection")
        public boolean afkGeneralProtection = true;
        @Setting(value="afk-command-protection")
        public boolean afkCommandProtection = false;
        @Setting(value="npc-compatibility-mode")
        public boolean npcCompatibilty = false;

        private LocalConfiguration() {
        }
    }
}

