/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.waves.types;

import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.things.Thing;
import com.garbagemule.MobArena.waves.AbstractWave;
import com.garbagemule.MobArena.waves.MACreature;
import com.garbagemule.MobArena.waves.Wave;
import com.garbagemule.MobArena.waves.enums.WaveType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;

public class UpgradeWave
extends AbstractWave {
    private Map<String, List<Thing>> upgrades;

    public UpgradeWave(Map<String, List<Thing>> upgrades) {
        this.upgrades = upgrades;
        this.setType(WaveType.UPGRADE);
    }

    @Override
    public Map<MACreature, Integer> getMonstersToSpawn(int wave, int playerCount, Arena arena) {
        return new HashMap<MACreature, Integer>();
    }

    public void grantItems(Player p, String className) {
        List<Thing> list = this.upgrades.get(className);
        if (list == null) {
            return;
        }
        list.forEach(thing -> thing.giveTo(p));
    }

    @Override
    public Wave copy() {
        HashMap<String, List<Thing>> upgrades = new HashMap<String, List<Thing>>();
        for (Map.Entry<String, List<Thing>> entry : this.upgrades.entrySet()) {
            upgrades.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        UpgradeWave result = new UpgradeWave(upgrades);
        result.setAmountMultiplier(this.getAmountMultiplier());
        result.setHealthMultiplier(this.getHealthMultiplier());
        result.setName(this.getName());
        result.setSpawnpoints(this.getSpawnpoints());
        result.setEffects(this.getEffects());
        return result;
    }
}

