/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.waves.types;

import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.waves.AbstractWave;
import com.garbagemule.MobArena.waves.MACreature;
import com.garbagemule.MobArena.waves.Wave;
import com.garbagemule.MobArena.waves.enums.WaveType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.SortedMap;
import org.bukkit.inventory.ItemStack;

public class SupplyWave
extends AbstractWave {
    private SortedMap<Integer, MACreature> monsterMap;
    private List<ItemStack> drops;

    public SupplyWave(SortedMap<Integer, MACreature> monsterMap) {
        this.monsterMap = monsterMap;
        this.setType(WaveType.SUPPLY);
    }

    @Override
    public Map<MACreature, Integer> getMonstersToSpawn(int wave, int playerCount, Arena arena) {
        int total = this.monsterMap.lastKey();
        Random random = new Random();
        HashMap<MACreature, Integer> monsters = new HashMap<MACreature, Integer>();
        int toSpawn = (int)Math.max(1.0, (double)playerCount * super.getAmountMultiplier());
        block0: for (int i = 0; i < toSpawn; ++i) {
            int value = random.nextInt(total) + 1;
            for (Map.Entry<Integer, MACreature> entry : this.monsterMap.entrySet()) {
                Integer current;
                if (value > entry.getKey()) continue;
                monsters.put(entry.getValue(), (current = (Integer)monsters.get(entry.getValue())) == null ? 1 : current + 1);
                continue block0;
            }
        }
        return monsters;
    }

    public List<ItemStack> getDropList() {
        return this.drops;
    }

    public void setDropList(List<ItemStack> drops) {
        this.drops = drops;
    }

    @Override
    public Wave copy() {
        SupplyWave result = new SupplyWave(this.monsterMap);
        result.drops = new ArrayList<ItemStack>(this.drops);
        result.setAmountMultiplier(this.getAmountMultiplier());
        result.setHealthMultiplier(this.getHealthMultiplier());
        result.setName(this.getName());
        result.setSpawnpoints(this.getSpawnpoints());
        result.setEffects(this.getEffects());
        return result;
    }
}

