/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.waves.ability.core;

import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.region.ArenaRegion;
import com.garbagemule.MobArena.waves.MABoss;
import com.garbagemule.MobArena.waves.ability.Ability;
import com.garbagemule.MobArena.waves.ability.AbilityInfo;
import com.garbagemule.MobArena.waves.ability.AbilityUtils;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

@AbilityInfo(name="Root Target", aliases={"roottarget", "freezetarget"})
public class RootTarget
implements Ability {
    private final int ITERATIONS = 30;
    private final int TICKS = 1;

    @Override
    public void execute(Arena arena, MABoss boss) {
        LivingEntity target = AbilityUtils.getTarget(arena, boss.getEntity(), true);
        if (target == null || !(target instanceof Player)) {
            return;
        }
        Player player = (Player)target;
        ArenaRegion region = arena.getRegion();
        Block block = player.getLocation().getBlock();
        Block solid = this.findSolidBlockBelow(region, block);
        Location location = player.getLocation();
        location.setY(solid.getLocation().getY() + 1.0);
        this.rootTarget(arena, player, location, 30);
    }

    private Block findSolidBlockBelow(ArenaRegion region, Block block) {
        Block below = block.getRelative(BlockFace.DOWN);
        if (!region.contains(below.getLocation())) {
            return block;
        }
        if (below.getType().isSolid()) {
            return below;
        }
        return this.findSolidBlockBelow(region, below);
    }

    private void rootTarget(final Arena arena, final Player p, final Location loc, final int counter) {
        if (counter <= 0) {
            return;
        }
        arena.scheduleTask(new Runnable(){

            @Override
            public void run() {
                if (!arena.isRunning() || !arena.inArena(p)) {
                    return;
                }
                p.teleport(loc);
                RootTarget.this.rootTarget(arena, p, loc, counter - 1);
            }
        }, 1);
    }
}

