/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.waves.ability;

import com.garbagemule.MobArena.waves.ability.Ability;
import com.garbagemule.MobArena.waves.ability.AbilityInfo;
import com.garbagemule.MobArena.waves.ability.core.ChainLightning;
import com.garbagemule.MobArena.waves.ability.core.DisorientDistant;
import com.garbagemule.MobArena.waves.ability.core.DisorientNearby;
import com.garbagemule.MobArena.waves.ability.core.DisorientTarget;
import com.garbagemule.MobArena.waves.ability.core.FetchDistant;
import com.garbagemule.MobArena.waves.ability.core.FetchNearby;
import com.garbagemule.MobArena.waves.ability.core.FetchTarget;
import com.garbagemule.MobArena.waves.ability.core.FireAura;
import com.garbagemule.MobArena.waves.ability.core.Flood;
import com.garbagemule.MobArena.waves.ability.core.LightningAura;
import com.garbagemule.MobArena.waves.ability.core.LivingBomb;
import com.garbagemule.MobArena.waves.ability.core.ObsidianBomb;
import com.garbagemule.MobArena.waves.ability.core.PullDistant;
import com.garbagemule.MobArena.waves.ability.core.PullNearby;
import com.garbagemule.MobArena.waves.ability.core.PullTarget;
import com.garbagemule.MobArena.waves.ability.core.RootTarget;
import com.garbagemule.MobArena.waves.ability.core.ShootArrow;
import com.garbagemule.MobArena.waves.ability.core.ShootFireball;
import com.garbagemule.MobArena.waves.ability.core.ShufflePositions;
import com.garbagemule.MobArena.waves.ability.core.ThrowDistant;
import com.garbagemule.MobArena.waves.ability.core.ThrowNearby;
import com.garbagemule.MobArena.waves.ability.core.ThrowTarget;
import com.garbagemule.MobArena.waves.ability.core.WarpToPlayer;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.bukkit.Bukkit;

public class AbilityManager {
    private static final String ma = "plugins" + File.separator + "MobArena.jar";
    private static final String cb = System.getProperty("java.class.path");
    private static final String classpath = ma + System.getProperty("path.separator") + cb;
    private static Map<String, Class<? extends Ability>> abilities;

    public static Ability getAbility(String alias) {
        try {
            Class<? extends Ability> cls = abilities.get(alias.toLowerCase().replaceAll("[-_.]", ""));
            return cls.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void loadCoreAbilities() {
        if (abilities == null) {
            abilities = new HashMap<String, Class<? extends Ability>>();
        }
        AbilityManager.register(ChainLightning.class);
        AbilityManager.register(DisorientDistant.class);
        AbilityManager.register(DisorientNearby.class);
        AbilityManager.register(DisorientTarget.class);
        AbilityManager.register(FetchDistant.class);
        AbilityManager.register(FetchNearby.class);
        AbilityManager.register(FetchTarget.class);
        AbilityManager.register(FireAura.class);
        AbilityManager.register(Flood.class);
        AbilityManager.register(LightningAura.class);
        AbilityManager.register(LivingBomb.class);
        AbilityManager.register(ObsidianBomb.class);
        AbilityManager.register(PullDistant.class);
        AbilityManager.register(PullNearby.class);
        AbilityManager.register(PullTarget.class);
        AbilityManager.register(RootTarget.class);
        AbilityManager.register(ShootArrow.class);
        AbilityManager.register(ShootFireball.class);
        AbilityManager.register(ShufflePositions.class);
        AbilityManager.register(ThrowDistant.class);
        AbilityManager.register(ThrowNearby.class);
        AbilityManager.register(ThrowTarget.class);
        AbilityManager.register(WarpToPlayer.class);
    }

    public static void loadCustomAbilities(File dataDir) {
        File classDir;
        if (abilities == null) {
            abilities = new HashMap<String, Class<? extends Ability>>();
        }
        if (!(classDir = new File(dataDir, "abilities")).exists()) {
            return;
        }
        File javaDir = new File(classDir, "src");
        if (javaDir.exists()) {
            if (ToolProvider.getSystemJavaCompiler() != null) {
                AbilityManager.compileAbilities(javaDir, classDir);
            } else {
                Bukkit.getLogger().warning("[MobArena] Found plugins/MobArena/abilities/src/ folder, but no Java compiler. The source files will not be compiled!");
            }
        }
        AbilityManager.loadClasses(classDir);
    }

    private static void register(Class<? extends Ability> cls) {
        AbilityManager.register(cls, false);
    }

    private static void register(Class<? extends Ability> cls, boolean announce) {
        AbilityInfo info = cls.getAnnotation(AbilityInfo.class);
        if (info == null) {
            return;
        }
        for (String alias : info.aliases()) {
            abilities.put(alias, cls);
        }
        if (announce) {
            Bukkit.getLogger().info("[MobArena] Loaded custom ability '" + info.name() + "'");
        }
    }

    private static void compileAbilities(File javaDir, File classDir) {
        if (!javaDir.exists()) {
            return;
        }
        List<File> toCompile = AbilityManager.getSourceFilesToCompile(javaDir, classDir);
        if (toCompile.isEmpty()) {
            return;
        }
        Bukkit.getLogger().info("[MobArena] Compiling abilities: " + AbilityManager.fileListToString(toCompile));
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
        try {
            Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(toCompile);
            List<String> options = Arrays.asList("-classpath", classpath, "-d", classDir.getPath());
            JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, null, options, null, compilationUnits);
            task.call();
            fileManager.close();
        }
        catch (Exception e) {
            Bukkit.getLogger().severe("[MobArena] Compilation step failed...");
            e.printStackTrace();
        }
    }

    private static List<File> getSourceFilesToCompile(File javaDir, File classDir) {
        ArrayList<File> result = new ArrayList<File>();
        if (javaDir == null || !javaDir.exists()) {
            return result;
        }
        File[] classFiles = classDir.listFiles();
        for (File javaFile : javaDir.listFiles()) {
            if (!javaFile.getName().endsWith(".java")) {
                Bukkit.getLogger().info("[MobArena] Found invalid ability file: " + javaFile.getName());
                continue;
            }
            File classFile = AbilityManager.findClassFile(javaFile, classFiles);
            if (AbilityManager.isClassFileNewer(javaFile, classFile)) continue;
            result.add(javaFile);
        }
        return result;
    }

    private static File findClassFile(File javaFile, File[] classFiles) {
        String javaFileName = javaFile.getName();
        String classFileName = javaFileName.substring(0, javaFileName.lastIndexOf(".")) + ".class";
        for (File classFile : classFiles) {
            if (!classFile.getName().equals(classFileName)) continue;
            return classFile;
        }
        return null;
    }

    private static boolean isClassFileNewer(File javaFile, File classFile) {
        if (classFile == null) {
            return false;
        }
        return classFile.lastModified() > javaFile.lastModified();
    }

    private static void loadClasses(File classDir) {
        ClassLoader loader = AbilityManager.getLoader(classDir);
        if (loader == null) {
            return;
        }
        for (File file : classDir.listFiles()) {
            String filename = file.getName();
            int dot = filename.lastIndexOf(".class");
            if (dot < 0) continue;
            String name = filename.substring(0, file.getName().lastIndexOf("."));
            try {
                Class<?> cls = loader.loadClass(name);
                if (!Ability.class.isAssignableFrom(cls)) continue;
                AbilityManager.register(cls.asSubclass(Ability.class), true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static ClassLoader getLoader(File dir) {
        try {
            URLClassLoader loader = new URLClassLoader(new URL[]{dir.toURI().toURL()}, Ability.class.getClassLoader());
            return loader;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String fileListToString(List<File> list) {
        return AbilityManager.fileListToString(list, null);
    }

    private static String fileListToString(List<File> list, String exclude) {
        if (list.isEmpty()) {
            return "";
        }
        StringBuffer buffy = new StringBuffer();
        for (File file : list) {
            String name = file.getName();
            int dot = name.lastIndexOf(".");
            if (exclude != null && name.contains(exclude)) continue;
            buffy.append(", " + name.substring(0, dot));
        }
        return buffy.substring(2);
    }
}

