/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.waves;

import com.garbagemule.MobArena.ConfigError;
import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.region.ArenaRegion;
import com.garbagemule.MobArena.things.InvalidThingInputString;
import com.garbagemule.MobArena.things.Thing;
import com.garbagemule.MobArena.things.ThingManager;
import com.garbagemule.MobArena.util.ItemParser;
import com.garbagemule.MobArena.util.PotionEffectParser;
import com.garbagemule.MobArena.waves.MACreature;
import com.garbagemule.MobArena.waves.Wave;
import com.garbagemule.MobArena.waves.WaveUtils;
import com.garbagemule.MobArena.waves.ability.Ability;
import com.garbagemule.MobArena.waves.ability.AbilityManager;
import com.garbagemule.MobArena.waves.enums.BossHealth;
import com.garbagemule.MobArena.waves.enums.SwarmAmount;
import com.garbagemule.MobArena.waves.enums.WaveBranch;
import com.garbagemule.MobArena.waves.enums.WaveGrowth;
import com.garbagemule.MobArena.waves.enums.WaveType;
import com.garbagemule.MobArena.waves.types.BossWave;
import com.garbagemule.MobArena.waves.types.DefaultWave;
import com.garbagemule.MobArena.waves.types.SpecialWave;
import com.garbagemule.MobArena.waves.types.SupplyWave;
import com.garbagemule.MobArena.waves.types.SwarmWave;
import com.garbagemule.MobArena.waves.types.UpgradeWave;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;

public class WaveParser {
    public static TreeSet<Wave> parseWaves(Arena arena, ConfigurationSection config, WaveBranch branch) {
        TreeSet<Wave> result = new TreeSet<Wave>(WaveUtils.getComparator(branch));
        if (config == null) {
            return result;
        }
        Set waves = config.getKeys(false);
        if (waves == null) {
            return result;
        }
        for (String wave : waves) {
            ConfigurationSection waveSection = config.getConfigurationSection(wave);
            Wave w = WaveParser.parseWave(arena, wave, waveSection, branch);
            result.add(w);
        }
        return result;
    }

    public static Wave parseWave(Arena arena, String name, ConfigurationSection config, WaveBranch branch) {
        double amountMultiplier;
        String t = config.getString("type", null);
        WaveType type = WaveType.fromString(t);
        if (type == null) {
            throw new ConfigError("Invalid wave type for wave " + name + " of arena " + arena.configName() + ": " + t);
        }
        Wave result = null;
        switch (type) {
            case DEFAULT: {
                result = WaveParser.parseDefaultWave(arena, name, config);
                break;
            }
            case SPECIAL: {
                result = WaveParser.parseSpecialWave(arena, name, config);
                break;
            }
            case SWARM: {
                result = WaveParser.parseSwarmWave(arena, name, config);
                break;
            }
            case SUPPLY: {
                result = WaveParser.parseSupplyWave(arena, name, config);
                break;
            }
            case UPGRADE: {
                result = WaveParser.parseUpgradeWave(arena, name, config);
                break;
            }
            case BOSS: {
                result = WaveParser.parseBossWave(arena, name, config);
            }
        }
        int priority = config.getInt("priority", -1);
        int frequency = config.getInt("frequency", -1);
        int firstWave = config.getInt("wave", frequency);
        double healthMultiplier = config.getDouble("health-multiplier", -1.0);
        if (healthMultiplier == -1.0) {
            healthMultiplier = config.getInt("health-multiplier", 1);
        }
        if ((amountMultiplier = config.getDouble("amount-multiplier", -1.0)) == -1.0) {
            amountMultiplier = config.getInt("amount-multiplier", 1);
        }
        List<Location> spawnpoints = WaveParser.getSpawnpoints(arena, name, config);
        List<PotionEffect> effects = WaveParser.getPotionEffects(arena, name, config);
        if (branch == WaveBranch.RECURRENT) {
            if (priority <= 0) {
                throw new ConfigError("Missing or invalid 'priority' node for recurrent wave " + name + " of arena " + arena.configName());
            }
            if (frequency <= 0) {
                throw new ConfigError("Missing or invalid 'frequency' node for recurrent wave " + name + " of arena " + arena.configName());
            }
        } else if (branch == WaveBranch.SINGLE && firstWave <= 0) {
            throw new ConfigError("Missing or invalid 'wave' node for single wave " + name + " of arena " + arena.configName());
        }
        result.setName(name);
        result.setBranch(branch);
        result.setFirstWave(firstWave);
        result.setPriority(priority);
        result.setFrequency(frequency);
        result.setHealthMultiplier(healthMultiplier);
        result.setAmountMultiplier(amountMultiplier);
        result.setSpawnpoints(spawnpoints);
        result.setEffects(effects);
        return result;
    }

    private static Wave parseDefaultWave(Arena arena, String name, ConfigurationSection config) {
        SortedMap<Integer, MACreature> monsters = WaveParser.getMonsterMap(arena, name, config);
        DefaultWave result = new DefaultWave(monsters);
        boolean fixed = config.getBoolean("fixed", false);
        if (fixed) {
            result.setFixed(true);
            return result;
        }
        String grw = config.getString("growth", null);
        if (grw != null && !grw.isEmpty()) {
            try {
                WaveGrowth growth = WaveGrowth.valueOf(grw.toUpperCase());
                result.setGrowth(growth);
            }
            catch (IllegalArgumentException e) {
                throw new ConfigError("Failed to parse wave growth for wave " + name + " of arena " + arena.configName() + ": " + grw);
            }
        } else {
            result.setGrowth(WaveGrowth.MEDIUM);
        }
        return result;
    }

    private static Wave parseSpecialWave(Arena arena, String name, ConfigurationSection config) {
        SortedMap<Integer, MACreature> monsters = WaveParser.getMonsterMap(arena, name, config);
        return new SpecialWave(monsters);
    }

    private static Wave parseSwarmWave(Arena arena, String name, ConfigurationSection config) {
        MACreature monster = WaveParser.getSingleMonster(arena, name, config);
        SwarmWave result = new SwarmWave(monster);
        String amnt = config.getString("amount", null);
        if (amnt != null && !amnt.isEmpty()) {
            try {
                SwarmAmount amount = SwarmAmount.valueOf(amnt.toUpperCase());
                result.setAmount(amount);
            }
            catch (IllegalArgumentException e) {
                throw new ConfigError("Failed to parse wave amount for wave " + name + " of arena " + arena.configName() + ": " + amnt);
            }
        } else {
            result.setAmount(SwarmAmount.LOW);
        }
        return result;
    }

    private static Wave parseSupplyWave(Arena arena, String name, ConfigurationSection config) {
        SortedMap<Integer, MACreature> monsters = WaveParser.getMonsterMap(arena, name, config);
        SupplyWave result = new SupplyWave(monsters);
        List<String> loot = config.getStringList("drops");
        if (loot == null || loot.isEmpty()) {
            String value2 = config.getString("drops", null);
            if (value2 == null) {
                throw new ConfigError("Missing 'drops' node for wave " + name + " of arena " + arena.configName());
            }
            loot = Arrays.asList(value2.split(","));
        }
        List<ItemStack> stacks = loot.stream().map(String::trim).map(value -> {
            ItemStack stack = ItemParser.parseItem(value, false);
            if (stack == null) {
                throw new ConfigError("Failed to parse loot for wave " + name + " of arena " + arena.configName() + ": " + value);
            }
            return stack;
        }).collect(Collectors.toList());
        result.setDropList(stacks);
        return result;
    }

    private static Wave parseUpgradeWave(Arena arena, String name, ConfigurationSection config) {
        ThingManager thingman = arena.getPlugin().getThingManager();
        Map<String, List<Thing>> upgrades = WaveParser.getUpgradeMap(config, name, arena, thingman);
        return new UpgradeWave(upgrades);
    }

    private static Wave parseBossWave(Arena arena, String name, ConfigurationSection config) {
        List<Object> drops;
        String healthString;
        MACreature monster = WaveParser.getSingleMonster(arena, name, config);
        BossWave result = new BossWave(monster);
        String bossName = config.getString("name", null);
        if (bossName != null && !bossName.isEmpty()) {
            result.setBossName(bossName);
        }
        if ((healthString = config.getString("health", null)) != null && !healthString.isEmpty()) {
            try {
                BossHealth health = BossHealth.valueOf(healthString.toUpperCase());
                result.setHealth(health);
            }
            catch (IllegalArgumentException e) {
                int flatHealth = config.getInt("health", -1);
                if (flatHealth < 0) {
                    throw new ConfigError("Failed to parse boss health for wave " + name + " of arena " + arena.configName() + ": " + healthString);
                }
                result.setFlatHealth(flatHealth);
            }
        } else {
            result.setHealth(BossHealth.MEDIUM);
        }
        List<Object> abilities = config.getStringList("abilities");
        if (abilities == null || abilities.isEmpty()) {
            String value2 = config.getString("abilities", null);
            abilities = value2 == null ? Collections.emptyList() : Arrays.asList(value2.split(","));
        }
        if (abilities.isEmpty()) {
            arena.getPlugin().getLogger().warning("No boss abilities for boss wave " + name + " of arena " + arena.configName());
        }
        abilities.stream().map(String::trim).map(value -> {
            Ability ability = AbilityManager.getAbility(value);
            if (ability == null) {
                throw new ConfigError("Failed to parse boss ability for boss wave " + name + " of arena " + arena.configName() + ": " + value);
            }
            return ability;
        }).forEach(result::addBossAbility);
        result.setAbilityInterval(config.getInt("ability-interval", 3) * 20);
        result.setAbilityAnnounce(config.getBoolean("ability-announce", true));
        String rew = config.getString("reward", null);
        if (rew != null && !rew.isEmpty()) {
            try {
                Thing thing = arena.getPlugin().getThingManager().parse(rew.trim());
                result.setReward(thing);
            }
            catch (InvalidThingInputString e) {
                throw new ConfigError("Failed to parse boss reward in wave " + name + " of arena " + arena.configName() + ": " + e.getInput());
            }
        }
        if ((drops = config.getStringList("drops")) == null || drops.isEmpty()) {
            String value3 = config.getString("drops", null);
            drops = value3 == null ? Collections.emptyList() : Arrays.asList(value3.split(","));
        }
        List<ItemStack> stacks = drops.stream().map(String::trim).map(value -> {
            ItemStack stack = ItemParser.parseItem(value, false);
            if (stack == null) {
                throw new ConfigError("Failed to parse boss drop in wave " + name + " of arena " + arena.configName() + ": " + value);
            }
            return stack;
        }).collect(Collectors.toList());
        result.setDrops(stacks);
        return result;
    }

    private static MACreature getSingleMonster(Arena arena, String name, ConfigurationSection config) {
        String monster = config.getString("monster", null);
        if (monster == null || monster.isEmpty()) {
            throw new ConfigError("Missing 'monster' node for wave " + name + " of arena " + arena.configName());
        }
        MACreature result = MACreature.fromString(monster);
        if (result == null) {
            throw new ConfigError("Failed to parse monster for wave " + name + " of arena " + arena.configName() + ": " + monster);
        }
        return result;
    }

    private static SortedMap<Integer, MACreature> getMonsterMap(Arena arena, String name, ConfigurationSection config) {
        ConfigurationSection section = config.getConfigurationSection("monsters");
        if (section == null) {
            throw new ConfigError("Missing 'monsters' node for wave " + name + " of arena " + arena.configName());
        }
        Set monsters = section.getKeys(false);
        if (monsters == null || monsters.isEmpty()) {
            throw new ConfigError("Empty 'monsters' node for wave " + name + " of arena " + arena.configName());
        }
        TreeMap<Integer, MACreature> monsterMap = new TreeMap<Integer, MACreature>();
        int sum = 0;
        String path = "monsters.";
        for (String monster : monsters) {
            MACreature creature = MACreature.fromString(monster);
            if (creature == null) {
                throw new ConfigError("Failed to parse monster for wave " + name + " of arena " + arena.configName() + ": " + monster);
            }
            int prob = config.getInt(path + monster, -1);
            if (prob < 0) {
                throw new ConfigError("Failed to parse probability for monster " + monster + " in wave " + name + " of arena " + arena.configName());
            }
            monsterMap.put(sum += prob, creature);
        }
        return monsterMap;
    }

    private static List<Location> getSpawnpoints(Arena arena, String name, ConfigurationSection config) {
        List<String> spawnpoints = config.getStringList("spawnpoints");
        if (spawnpoints == null || spawnpoints.isEmpty()) {
            String value2 = config.getString("spawnpoints", null);
            if (value2 == null || value2.isEmpty()) {
                return Collections.emptyList();
            }
            spawnpoints = Arrays.asList(value2.split(";"));
        }
        ArenaRegion region = arena.getRegion();
        return spawnpoints.stream().map(String::trim).map(value -> {
            Location spawnpoint = region.getSpawnpoint((String)value);
            if (spawnpoint == null) {
                throw new ConfigError("Spawnpoint '" + value + "' in wave '" + name + "' for arena '" + arena.configName() + "' could not be parsed!");
            }
            return spawnpoint;
        }).collect(Collectors.toList());
    }

    private static List<PotionEffect> getPotionEffects(Arena arena, String name, ConfigurationSection config) {
        List effects = config.getStringList("effects");
        if (effects == null || effects.isEmpty()) {
            String value = config.getString("effects", null);
            if (value != null && !value.isEmpty()) {
                effects = Arrays.asList(value.split(","));
            } else {
                effects = config.getStringList("potions");
                if (effects == null || effects.isEmpty()) {
                    value = config.getString("potions", null);
                    if (value != null && !value.isEmpty()) {
                        effects = Arrays.asList(value.split(","));
                    } else {
                        return Collections.emptyList();
                    }
                }
            }
        }
        return effects.stream().map(String::trim).map(input -> {
            PotionEffect effect = PotionEffectParser.parsePotionEffect(input, false);
            if (effect == null) {
                throw new ConfigError("Failed to parse potion effect for wave " + name + " of arena " + arena.configName() + ": " + input);
            }
            return effect;
        }).collect(Collectors.toList());
    }

    private static Map<String, List<Thing>> getUpgradeMap(ConfigurationSection config, String name, Arena arena, ThingManager thingman) {
        ConfigurationSection section = config.getConfigurationSection("upgrades");
        if (section == null) {
            throw new ConfigError("Missing 'upgrades' node for wave " + name + " of arena " + arena.configName());
        }
        Set classes = section.getKeys(false);
        if (classes == null || classes.isEmpty()) {
            throw new ConfigError("Empty 'upgrades' node for wave " + name + " of arena " + arena.configName());
        }
        HashMap<String, List<Thing>> upgrades = new HashMap<String, List<Thing>>();
        String path = "upgrades.";
        for (String className : classes) {
            Object val = config.get(path + className, null);
            if (val instanceof String) {
                List<Thing> things = WaveParser.loadUpgradesFromString(className, (String)val, name, arena, thingman);
                upgrades.put(className.toLowerCase(), things);
                continue;
            }
            if (!(val instanceof ConfigurationSection)) continue;
            List<Thing> list = WaveParser.loadUpgradesFromSection(className, (ConfigurationSection)val, name, arena, thingman);
            upgrades.put(className.toLowerCase(), list);
        }
        return upgrades;
    }

    private static List<Thing> loadUpgradesFromString(String className, String value, String name, Arena arena, ThingManager thingman) {
        if (value == null || value.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            return Arrays.stream(value.split(",")).map(String::trim).map(thingman::parse).collect(Collectors.toList());
        }
        catch (InvalidThingInputString e) {
            throw new ConfigError("Failed to parse upgrades for class " + className + " in wave " + name + " of arena " + arena.configName() + ": " + e.getInput());
        }
    }

    private static List<Thing> loadUpgradesFromSection(String className, ConfigurationSection classSection, String name, Arena arena, ThingManager thingman) {
        ArrayList<Thing> list = new ArrayList<Thing>();
        List<Object> items = classSection.getStringList("items");
        if (items == null || items.isEmpty()) {
            String value = classSection.getString("items", null);
            items = value == null || value.isEmpty() ? Collections.emptyList() : Arrays.asList(value.split(","));
        }
        try {
            items.stream().map(String::trim).map(thingman::parse).forEach(list::add);
        }
        catch (InvalidThingInputString e) {
            throw new ConfigError("Failed to parse item upgrades for class " + className + " in wave " + name + " of arena " + arena.configName() + ": " + e.getInput());
        }
        List<Object> armor = classSection.getStringList("armor");
        if (armor == null || armor.isEmpty()) {
            String value = classSection.getString("armor", null);
            armor = value == null || value.isEmpty() ? Collections.emptyList() : Arrays.asList(value.split(","));
        }
        try {
            armor.stream().map(String::trim).map(s -> thingman.parse("armor", (String)s)).forEach(list::add);
        }
        catch (InvalidThingInputString e) {
            throw new ConfigError("Failed to parse armor upgrades for class " + className + " in wave " + name + " of arena " + arena.configName() + ": " + e.getInput());
        }
        List<Object> effects = classSection.getStringList("effects");
        if (effects == null || effects.isEmpty()) {
            String value = classSection.getString("effects", null);
            effects = value == null || value.isEmpty() ? Collections.emptyList() : Arrays.asList(value.split(","));
        }
        try {
            effects.stream().map(String::trim).map(s -> thingman.parse("effect", (String)s)).forEach(list::add);
        }
        catch (InvalidThingInputString e) {
            throw new ConfigError("Failed to parse potion effects for class " + className + " in wave " + name + " of arena " + arena.configName() + ": " + e.getInput());
        }
        try {
            classSection.getStringList("permissions").stream().map(perm -> thingman.parse("perm", (String)perm)).forEach(list::add);
        }
        catch (InvalidThingInputString e) {
            throw new ConfigError("Failed to parse permission upgrades for class " + className + " in wave " + name + " of arena " + arena.configName() + ": " + e.getInput());
        }
        return list;
    }

    public static Wave createDefaultWave() {
        TreeMap<Integer, MACreature> monsters = new TreeMap<Integer, MACreature>();
        monsters.put(10, MACreature.ZOMBIE);
        monsters.put(20, MACreature.SKELETON);
        monsters.put(30, MACreature.SPIDER);
        monsters.put(40, MACreature.SLIMESMALL);
        DefaultWave result = new DefaultWave(monsters);
        result.setName("MA_DEFAULT_WAVE");
        result.setBranch(WaveBranch.RECURRENT);
        result.setFirstWave(1);
        result.setPriority(1);
        result.setFrequency(1);
        result.setGrowth(WaveGrowth.OLD);
        result.setHealthMultiplier(1.0);
        result.setAmountMultiplier(1.0);
        return result;
    }
}

