/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.waves;

import com.garbagemule.MobArena.MobArena;
import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.waves.WaveUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.inventory.ItemStack;

public class MACreature {
    private static Map<String, MACreature> map = new HashMap<String, MACreature>();
    public static final MACreature ZOMBIE;
    public static final MACreature SKELETON;
    public static final MACreature SPIDER;
    public static final MACreature CREEPER;
    public static final MACreature WOLF;
    public static final MACreature ZOMBIEPIGMAN;
    public static final MACreature POWEREDCREEPER;
    public static final MACreature ANGRYWOLF;
    public static final MACreature ENDERMAN;
    public static final MACreature SNOWMAN;
    public static final MACreature SNOWGOLEM;
    public static final MACreature MOOSHROOM;
    public static final MACreature SHEEP;
    public static final MACreature EXPLODINGSHEEP;
    public static final MACreature SLIMETINY;
    public static final MACreature SLIMESMALL;
    public static final MACreature SLIMEBIG;
    public static final MACreature SLIMEHUGE;
    public static final MACreature MAGMACUBETINY;
    public static final MACreature MAGMACUBESMALL;
    public static final MACreature MAGMACUBEBIG;
    public static final MACreature MAGMACUBEHUGE;
    public static final MACreature WITCH;
    public static final MACreature BABYZOMBIE;
    public static final MACreature BABYPIGMAN;
    public static final MACreature BABYZOMBIEVILLAGER;
    public static final MACreature UNDEADHORSE;
    public static final MACreature KILLERBUNNY;
    private List<DyeColor> colors = Arrays.asList(DyeColor.values());
    private String name;
    private String plural;
    private EntityType type;

    public MACreature(String name, String plural, EntityType type) {
        this.name = name;
        this.plural = plural != null ? plural : name;
        this.type = type;
        this.register();
    }

    public MACreature(String name, EntityType type) {
        this(name, name + "s", type);
    }

    private MACreature(EntityType type) {
        this(type.name().toLowerCase().replaceAll("[-_\\.]", ""), type.name().toLowerCase().replaceAll("[-_\\.]", "") + "s", type);
    }

    private void register() {
        map.put(this.name, this);
        map.put(this.plural, this);
    }

    public String getName() {
        return this.name;
    }

    public EntityType getType() {
        return this.type;
    }

    public static MACreature fromString(String string) {
        return map.get(string.toLowerCase().replaceAll("[-_\\.]", ""));
    }

    public LivingEntity spawn(Arena arena, World world, Location loc) {
        LivingEntity e = (LivingEntity)world.spawnEntity(loc, this.type);
        e.getEquipment().clear();
        e.setCanPickupItems(false);
        switch (this.name) {
            case "sheep": {
                ((Sheep)e).setColor(this.colors.get(MobArena.random.nextInt(this.colors.size())));
                break;
            }
            case "explodingsheep": {
                arena.getMonsterManager().addExplodingSheep(e);
                ((Sheep)e).setColor(DyeColor.RED);
                break;
            }
            case "poweredcreeper": {
                ((Creeper)e).setPowered(true);
                break;
            }
            case "angrywolf": {
                ((Wolf)e).setAngry(true);
                break;
            }
            case "slime": 
            case "magmacube": {
                ((Slime)e).setSize(1 + MobArena.random.nextInt(3));
                break;
            }
            case "slimetiny": 
            case "magmacubetiny": {
                ((Slime)e).setSize(1);
                break;
            }
            case "slimesmall": 
            case "magmacubesmall": {
                ((Slime)e).setSize(2);
                break;
            }
            case "slimebig": 
            case "magmacubebig": {
                ((Slime)e).setSize(3);
                break;
            }
            case "slimehuge": 
            case "magmacubehuge": {
                ((Slime)e).setSize(4);
                break;
            }
            case "skeleton": 
            case "stray": {
                e.getEquipment().setItemInMainHand(new ItemStack(Material.BOW, 1));
                break;
            }
            case "babyzombievillager": 
            case "babyzombie": {
                ((Zombie)e).setBaby(true);
                break;
            }
            case "babypigman": {
                ((Zombie)e).setBaby(true);
                ((PigZombie)e).setAngry(true);
                break;
            }
            case "pigzombie": 
            case "zombiepigman": {
                ((PigZombie)e).setAngry(true);
                break;
            }
            case "killerbunny": {
                ((Rabbit)e).setRabbitType(Rabbit.Type.THE_KILLER_BUNNY);
                break;
            }
            case "witherskeleton": {
                e.getEquipment().setItemInMainHand(new ItemStack(Material.STONE_SWORD, 1));
                break;
            }
        }
        if (e instanceof Creature) {
            Creature c = (Creature)e;
            c.setTarget((LivingEntity)WaveUtils.getClosestPlayer(arena, (Entity)e));
        }
        return e;
    }

    static {
        for (EntityType type : EntityType.values()) {
            if (!type.isAlive()) continue;
            new MACreature(type);
        }
        ZOMBIE = new MACreature("zombie", EntityType.ZOMBIE);
        SKELETON = new MACreature("skeleton", EntityType.SKELETON);
        SPIDER = new MACreature("spider", EntityType.SPIDER);
        CREEPER = new MACreature("creeper", EntityType.CREEPER);
        WOLF = new MACreature("wolf", "wolves", EntityType.WOLF);
        ZOMBIEPIGMAN = new MACreature("zombiepigman", "zombiepigmen", EntityType.PIG_ZOMBIE);
        POWEREDCREEPER = new MACreature("poweredcreeper", EntityType.CREEPER);
        ANGRYWOLF = new MACreature("angrywolf", "angrywolves", EntityType.WOLF);
        ENDERMAN = new MACreature("enderman", "endermen", EntityType.ENDERMAN);
        SNOWMAN = new MACreature("snowman", "snowmen", EntityType.SNOWMAN);
        SNOWGOLEM = new MACreature("snowgolem", EntityType.SNOWMAN);
        MOOSHROOM = new MACreature("mooshroom", EntityType.MUSHROOM_COW);
        SHEEP = new MACreature("sheep", null, EntityType.SHEEP);
        EXPLODINGSHEEP = new MACreature("explodingsheep", null, EntityType.SHEEP);
        SLIMETINY = new MACreature("slimetiny", "slimestiny", EntityType.SLIME);
        SLIMESMALL = new MACreature("slimesmall", "slimessmall", EntityType.SLIME);
        SLIMEBIG = new MACreature("slimebig", "slimesbig", EntityType.SLIME);
        SLIMEHUGE = new MACreature("slimehuge", "slimeshuge", EntityType.SLIME);
        MAGMACUBETINY = new MACreature("magmacubetiny", "magmacubestiny", EntityType.MAGMA_CUBE);
        MAGMACUBESMALL = new MACreature("magmacubesmall", "magmacubessmall", EntityType.MAGMA_CUBE);
        MAGMACUBEBIG = new MACreature("magmacubebig", "magmacubesbig", EntityType.MAGMA_CUBE);
        MAGMACUBEHUGE = new MACreature("magmacubehuge", "magmacubeshuge", EntityType.MAGMA_CUBE);
        WITCH = new MACreature("witch", "witches", EntityType.WITCH);
        BABYZOMBIE = new MACreature("babyzombie", EntityType.ZOMBIE);
        BABYPIGMAN = new MACreature("babypigman", "babypigmen", EntityType.PIG_ZOMBIE);
        BABYZOMBIEVILLAGER = new MACreature("babyzombievillager", EntityType.ZOMBIE_VILLAGER);
        UNDEADHORSE = new MACreature("undeadhorse", EntityType.ZOMBIE_HORSE);
        KILLERBUNNY = new MACreature("killerbunny", "killerbunnies", EntityType.RABBIT);
    }
}

