/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.waves;

import com.garbagemule.MobArena.healthbar.HealthBar;
import com.garbagemule.MobArena.things.Thing;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;

public class MABoss {
    private LivingEntity entity;
    private boolean dead;
    private Thing reward;
    private List<ItemStack> drops;
    private HealthBar healthbar;

    public MABoss(LivingEntity entity, double maxHealth) {
        try {
            entity.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(maxHealth);
            entity.setHealth(maxHealth);
        }
        catch (IllegalArgumentException ex) {
            Bukkit.getLogger().severe("[MobArena] Can't set health to " + maxHealth + ", using default health. If you are running Spigot, set 'maxHealth' higher in your Spigot settings.");
            Bukkit.getLogger().severe("[MobArena] " + ex.getLocalizedMessage());
        }
        this.entity = entity;
        this.dead = false;
    }

    public LivingEntity getEntity() {
        return this.entity;
    }

    public double getHealth() {
        return this.entity.getHealth();
    }

    public double getMaxHealth() {
        return this.entity.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue();
    }

    public boolean isDead() {
        return this.dead;
    }

    public void setDead(boolean dead) {
        this.dead = dead;
        this.healthbar.removeAll();
    }

    public void setReward(Thing reward) {
        this.reward = reward;
    }

    public Thing getReward() {
        return this.reward;
    }

    public void setDrops(List<ItemStack> drops) {
        this.drops = drops;
    }

    public List<ItemStack> getDrops() {
        return this.drops;
    }

    public HealthBar getHealthBar() {
        return this.healthbar;
    }

    public void setHealthBar(HealthBar healthbar) {
        this.healthbar = healthbar;
    }
}

