/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.util.timer;

import com.garbagemule.MobArena.Msg;
import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.util.timer.Common;
import com.garbagemule.MobArena.util.timer.CountdownTimer;
import com.garbagemule.MobArena.util.timer.TimerCallbackAdapter;

public class ChatCallback
extends TimerCallbackAdapter {
    private Arena arena;
    private Msg msg;
    private CountdownTimer timer;
    private int[] triggers;
    private int index;

    public ChatCallback(Arena arena, Msg msg, CountdownTimer timer, int[] triggers) {
        this.arena = arena;
        this.msg = msg;
        this.timer = timer;
        this.triggers = triggers;
        this.index = 0;
    }

    @Override
    public void onStart() {
        long duration = this.timer.getDuration();
        this.index = 0;
        while (this.index < this.triggers.length) {
            long trigger = Common.toTicks(this.triggers[this.index]);
            if (trigger < duration) {
                this.timer.setInterval(duration - trigger);
                break;
            }
            ++this.index;
        }
    }

    @Override
    public void onTick() {
        long ticks = this.timer.getRemaining();
        int seconds = Common.toSeconds(ticks);
        this.arena.announce(this.msg, String.valueOf(seconds));
        ++this.index;
        if (this.index < this.triggers.length) {
            long trigger = Common.toTicks(this.triggers[this.index]);
            this.timer.setInterval(ticks - trigger);
        }
    }
}

