/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.util;

import java.util.Date;

public class TimeUtils {
    public static String toTime(long ms) {
        long total = ms / 1000L;
        long secs = total % 60L;
        long mins = total % 3600L / 60L;
        long hours = total / 3600L % 24L;
        long days = total / 3600L / 24L;
        String time = (days > 0L ? days + ":" : "") + (hours < 10L ? "0" + hours : Long.valueOf(hours)) + ":" + (mins < 10L ? "0" + mins : Long.valueOf(mins)) + ":" + (secs < 10L ? "0" + secs : Long.valueOf(secs));
        return time;
    }

    public static String toDateTime(long ms) {
        return new Date(ms).toString();
    }

    public static String addTimes(String t1, String t2) {
        String[] parts1 = t1.split(":");
        String[] parts2 = t2.split(":");
        long secs1 = TimeUtils.extractSeconds(parts1);
        long secs2 = TimeUtils.extractSeconds(parts2);
        long mins1 = TimeUtils.extractMinutes(parts1);
        long mins2 = TimeUtils.extractMinutes(parts2);
        long hours1 = TimeUtils.extractHours(parts1);
        long hours2 = TimeUtils.extractHours(parts2);
        long days1 = TimeUtils.extractDays(parts1);
        long days2 = TimeUtils.extractDays(parts2);
        long time = (secs1 + secs2 + mins1 + mins2 + hours1 + hours2 + days1 + days2) * 1000L;
        return TimeUtils.toTime(time);
    }

    private static long extractSeconds(String[] parts) {
        int length = parts.length;
        if (length < 1) {
            return 0L;
        }
        return Long.parseLong(parts[length - 1]);
    }

    private static long extractMinutes(String[] parts) {
        int length = parts.length;
        if (length < 2) {
            return 0L;
        }
        return Long.parseLong(parts[length - 2]) * 60L;
    }

    private static long extractHours(String[] parts) {
        int length = parts.length;
        if (length < 3) {
            return 0L;
        }
        return Long.parseLong(parts[length - 3]) * 3600L;
    }

    private static long extractDays(String[] parts) {
        int length = parts.length;
        if (length < 4) {
            return 0L;
        }
        return Long.parseLong(parts[length - 4]) * 24L * 3600L;
    }
}

