/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.util;

import com.garbagemule.MobArena.Msg;
import com.garbagemule.MobArena.framework.Arena;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class JoinInterruptTimer {
    private Set<UUID> waiting = new HashSet<UUID>();

    public boolean isWaiting(Player player) {
        return this.waiting.contains(player.getUniqueId());
    }

    public boolean start(Player player, Arena arena, int seconds, Runnable completed) {
        if (this.isWaiting(player)) {
            return false;
        }
        UUID id = player.getUniqueId();
        this.waiting.add(id);
        TimedInterruptListener listener = new TimedInterruptListener(player, arena, () -> this.waiting.remove(id), completed);
        listener.runTaskLater((Plugin)arena.getPlugin(), seconds * 20);
        Bukkit.getPluginManager().registerEvents((Listener)listener, (Plugin)arena.getPlugin());
        return true;
    }

    static class TimedInterruptListener
    extends BukkitRunnable
    implements Listener {
        Player player;
        Location location;
        Arena arena;
        Runnable stopped;
        Runnable completed;
        boolean done;

        TimedInterruptListener(Player player, Arena arena, Runnable stopped, Runnable completed) {
            this.player = player;
            this.location = player.getLocation();
            this.arena = arena;
            this.stopped = stopped;
            this.completed = completed;
            this.done = false;
        }

        public void run() {
            this.complete();
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void on(EntityDamageEvent event) {
            if (this.done || !event.getEntity().equals(this.player)) {
                return;
            }
            this.arena.getMessenger().tell((CommandSender)this.player, Msg.JOIN_INTERRUPTED_BY_DAMAGE);
            this.interrupt();
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void on(PlayerMoveEvent event) {
            if (this.done || !event.getPlayer().equals(this.player)) {
                return;
            }
            if (this.location.getWorld() == event.getTo().getWorld() && this.location.distanceSquared(event.getTo()) < 1.0) {
                return;
            }
            this.arena.getMessenger().tell((CommandSender)this.player, Msg.JOIN_INTERRUPTED_BY_MOVEMENT);
            this.interrupt();
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void on(PlayerQuitEvent event) {
            if (this.done || !event.getPlayer().equals(this.player)) {
                return;
            }
            this.interrupt();
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void on(PlayerKickEvent event) {
            if (this.done || !event.getPlayer().equals(this.player)) {
                return;
            }
            this.interrupt();
        }

        void complete() {
            if (this.done) {
                return;
            }
            this.done = true;
            try {
                HandlerList.unregisterAll((Listener)this);
                this.stopped.run();
                this.completed.run();
            }
            finally {
                this.clear();
            }
        }

        void interrupt() {
            if (this.done) {
                return;
            }
            this.done = true;
            try {
                HandlerList.unregisterAll((Listener)this);
                this.stopped.run();
                super.cancel();
            }
            catch (IllegalStateException illegalStateException) {
            }
            finally {
                this.clear();
            }
        }

        void clear() {
            this.player = null;
            this.location = null;
            this.arena = null;
            this.stopped = null;
            this.completed = null;
        }
    }
}

