/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.things;

import com.garbagemule.MobArena.MobArena;
import com.garbagemule.MobArena.things.Thing;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.Plugin;

public class PermissionThing
implements Thing {
    private final String perm;
    private final boolean value;
    private final MobArena plugin;

    public PermissionThing(String perm, boolean value, MobArena plugin) {
        this.perm = perm;
        this.value = value;
        this.plugin = plugin;
    }

    @Override
    public boolean giveTo(Player player) {
        this.removeExistingAttachment(player);
        PermissionAttachment attachment = player.addAttachment((Plugin)this.plugin);
        attachment.setPermission(this.perm, this.value);
        return true;
    }

    @Override
    public boolean takeFrom(Player player) {
        this.removeExistingAttachment(player);
        return true;
    }

    private void removeExistingAttachment(Player player) {
        player.getEffectivePermissions().stream().filter(info -> info.getAttachment() != null).filter(info -> info.getAttachment().getPlugin().equals((Object)this.plugin)).filter(info -> info.getPermission().equals(this.perm)).map(PermissionAttachmentInfo::getAttachment).findAny().ifPresent(PermissionAttachment::remove);
    }

    String getPermission() {
        return this.perm;
    }

    boolean getValue() {
        return this.value;
    }

    @Override
    public boolean heldBy(Player player) {
        return player.hasPermission(this.perm);
    }

    public String toString() {
        if (this.value) {
            return this.perm;
        }
        return "-" + this.perm;
    }
}

