/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.things;

import com.garbagemule.MobArena.things.Thing;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class MoneyThing
implements Thing {
    private Economy economy;
    private double amount;

    public MoneyThing(Economy economy, double amount) {
        this.economy = economy;
        this.amount = amount;
    }

    @Override
    public boolean giveTo(Player player) {
        if (this.economy == null) {
            return false;
        }
        EconomyResponse result = this.economy.depositPlayer((OfflinePlayer)player, this.amount);
        return result.type == EconomyResponse.ResponseType.SUCCESS;
    }

    @Override
    public boolean takeFrom(Player player) {
        if (this.economy == null) {
            return false;
        }
        EconomyResponse result = this.economy.withdrawPlayer((OfflinePlayer)player, this.amount);
        return result.type == EconomyResponse.ResponseType.SUCCESS;
    }

    @Override
    public boolean heldBy(Player player) {
        if (this.economy == null) {
            return false;
        }
        return this.economy.getBalance((OfflinePlayer)player) >= this.amount;
    }

    public String toString() {
        if (this.economy == null) {
            return "$" + this.amount;
        }
        return this.economy.format(this.amount);
    }
}

