/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.things;

import com.garbagemule.MobArena.things.Thing;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemStackThing
implements Thing {
    private ItemStack stack;

    public ItemStackThing(ItemStack stack) {
        this.stack = stack;
    }

    @Override
    public boolean giveTo(Player player) {
        return player.getInventory().addItem(new ItemStack[]{this.stack.clone()}).isEmpty();
    }

    @Override
    public boolean takeFrom(Player player) {
        return player.getInventory().removeItem(new ItemStack[]{this.stack.clone()}).isEmpty();
    }

    @Override
    public boolean heldBy(Player player) {
        return player.getInventory().containsAtLeast(this.stack, this.stack.getAmount());
    }

    ItemStack getItemStack() {
        return this.stack;
    }

    public String toString() {
        String name = this.getName();
        int amount = this.stack.getAmount();
        if (amount > 1) {
            return amount + "x " + name;
        }
        return name;
    }

    private String getName() {
        ItemMeta meta = this.stack.getItemMeta();
        if (meta.hasDisplayName()) {
            return meta.getDisplayName();
        }
        return this.stack.getType().name().replace("_", " ").toLowerCase();
    }
}

