/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.things;

import com.garbagemule.MobArena.things.CommandThing;
import com.garbagemule.MobArena.things.ThingParser;

class CommandThingParser
implements ThingParser {
    private static final String PREFIX_LONG = "command";
    private static final String PREFIX_SHORT = "cmd";

    CommandThingParser() {
    }

    @Override
    public CommandThing parse(String s) {
        String trimmed = this.trimPrefix(s);
        if (trimmed == null) {
            return null;
        }
        if (trimmed.startsWith(":")) {
            return this.untitledCommand(trimmed);
        }
        if (trimmed.startsWith("(")) {
            return this.titledCommand(s, trimmed);
        }
        return null;
    }

    private String trimPrefix(String s) {
        if (s.startsWith(PREFIX_SHORT)) {
            return s.substring(PREFIX_SHORT.length()).trim();
        }
        if (s.startsWith(PREFIX_LONG)) {
            return s.substring(PREFIX_LONG.length()).trim();
        }
        return null;
    }

    private CommandThing untitledCommand(String trimmed) {
        String command = trimmed.substring(1).trim();
        return new CommandThing(command);
    }

    private CommandThing titledCommand(String s, String trimmed) {
        int end = this.findCloseParenthesis(trimmed);
        if (end == -1) {
            throw new IllegalArgumentException("Missing close parenthesis in " + s);
        }
        if (trimmed.length() <= end || trimmed.charAt(end + 1) != ':') {
            throw new IllegalArgumentException("Expected 'cmd(<name>):<command>' but got " + s);
        }
        String title = trimmed.substring(1, end);
        String command = trimmed.substring(end + 2).trim();
        return new CommandThing(command, title);
    }

    private int findCloseParenthesis(String trimmed) {
        int stack = 1;
        for (int i = 1; i < trimmed.length() - 1; ++i) {
            switch (trimmed.charAt(i)) {
                case '(': {
                    ++stack;
                    break;
                }
                case ')': {
                    --stack;
                }
            }
            if (stack != 0) continue;
            return i;
        }
        return -1;
    }
}

