/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.steps;

import com.garbagemule.MobArena.steps.PlayerStep;
import com.garbagemule.MobArena.steps.StepFactory;
import com.garbagemule.MobArena.time.Time;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

class SetPlayerTime
extends PlayerStep {
    private final Time time;

    private SetPlayerTime(Player player, Time time) {
        super(player);
        this.time = time;
    }

    @Override
    public void run() {
        if (this.time != null) {
            this.player.setPlayerTime((long)this.time.getTime(), false);
        }
    }

    @Override
    public void undo() {
        if (this.time != null) {
            this.player.resetPlayerTime();
        }
    }

    static StepFactory create(ConfigurationSection settings) {
        Time time = SetPlayerTime.parseTime(settings);
        return player -> new SetPlayerTime(player, time);
    }

    private static Time parseTime(ConfigurationSection settings) {
        String value = settings.getString("player-time-in-arena", "world");
        try {
            return Time.valueOf(value.toLowerCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

