/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.steps;

import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.steps.PlayerStep;
import com.garbagemule.MobArena.steps.StepFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.logging.Level;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

class ClearInventory
extends PlayerStep {
    private final File inventories;
    private final Arena arena;
    private ItemStack[] contents;
    private File backup;

    private ClearInventory(Player player, Arena arena) {
        super(player);
        this.inventories = new File(arena.getPlugin().getDataFolder(), "inventories");
        this.arena = arena;
    }

    @Override
    public void run() {
        this.contents = this.player.getInventory().getContents();
        this.createBackup();
        this.player.getInventory().clear();
    }

    @Override
    public void undo() {
        this.player.getInventory().setContents(this.contents);
        this.arena.getInventoryManager().remove(this.player);
        this.deleteBackup();
    }

    private void createBackup() {
        YamlConfiguration yaml = new YamlConfiguration();
        yaml.set("contents", (Object)this.contents);
        this.backup = new File(this.inventories, this.player.getUniqueId().toString());
        try {
            yaml.save(this.backup);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to store inventory for " + this.player.getName(), e);
        }
        this.arena.getInventoryManager().put(this.player, this.contents);
    }

    private void deleteBackup() {
        try {
            Files.delete(this.backup.toPath());
        }
        catch (IOException e) {
            this.arena.getPlugin().getLogger().log(Level.WARNING, "Couldn't delete backup inventory file for " + this.player.getName(), e);
        }
    }

    static StepFactory create(Arena arena) {
        return player -> new ClearInventory(player, arena);
    }
}

