/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.signs;

class Template {
    final String[] idle;
    final String[] joining;
    final String[] running;

    private Template(String[] idle, String[] joining, String[] running) {
        this.idle = idle;
        this.joining = joining;
        this.running = running;
    }

    static class Builder {
        private String id;
        private String[] base;
        private String[] idle;
        private String[] joining;
        private String[] running;

        Builder(String id) {
            this.id = id;
        }

        Builder withBase(String[] lines) {
            this.base = lines;
            return this;
        }

        Builder withIdle(String[] lines) {
            this.idle = lines;
            return this;
        }

        Builder withJoining(String[] lines) {
            this.joining = lines;
            return this;
        }

        Builder withRunning(String[] lines) {
            this.running = lines;
            return this;
        }

        Template build() {
            if (this.base == null) {
                if (this.idle == null) {
                    this.missing("idle");
                }
                if (this.joining == null) {
                    this.missing("joining");
                }
                if (this.running == null) {
                    this.missing("running");
                }
            }
            if (this.idle == null) {
                this.idle = this.base;
            }
            if (this.joining == null) {
                this.joining = this.base;
            }
            if (this.running == null) {
                this.running = this.base;
            }
            return new Template(this.idle, this.joining, this.running);
        }

        private void missing(String state) {
            String msg = "Missing either base template '" + this.id + "' or state template '" + this.id + "-" + state + "'";
            throw new IllegalArgumentException(msg);
        }
    }
}

