/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.signs;

import com.garbagemule.MobArena.signs.ArenaSign;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.Location;

class SignStore {
    static final String FILENAME = "signs.data";
    private final Map<Location, ArenaSign> signs;

    SignStore(List<ArenaSign> signs) {
        this.signs = signs.stream().collect(Collectors.toMap(sign -> sign.location, sign -> sign));
    }

    void store(ArenaSign sign) {
        this.signs.put(sign.location, sign);
    }

    Optional<ArenaSign> remove(Location location) {
        ArenaSign sign = this.signs.remove(location);
        return Optional.ofNullable(sign);
    }

    Collection<ArenaSign> findAll() {
        return this.signs.values();
    }

    Optional<ArenaSign> findByLocation(Location location) {
        ArenaSign sign = this.signs.get(location);
        return Optional.ofNullable(sign);
    }

    List<ArenaSign> findByArenaId(String arenaId) {
        return this.signs.values().stream().filter(sign -> sign.arenaId.equals(arenaId)).collect(Collectors.toList());
    }
}

