/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.signs;

import com.garbagemule.MobArena.MobArena;
import com.garbagemule.MobArena.signs.HandlesSignClicks;
import com.garbagemule.MobArena.signs.HandlesSignCreation;
import com.garbagemule.MobArena.signs.HandlesSignDestruction;
import com.garbagemule.MobArena.signs.RedrawsSignsOnUpdates;
import com.garbagemule.MobArena.signs.SignBootstrap;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class SignListeners {
    private final List<Listener> listeners = new ArrayList<Listener>();

    public void register(SignBootstrap bootstrap) {
        this.listeners.add(this.clicks(bootstrap));
        this.listeners.add(this.creation(bootstrap));
        this.listeners.add(this.destruction(bootstrap));
        this.listeners.add(this.redraw(bootstrap));
        this.listeners.forEach(listener -> this.register((Listener)listener, bootstrap));
    }

    private HandlesSignClicks clicks(SignBootstrap bootstrap) {
        return new HandlesSignClicks(bootstrap.getSignStore(), bootstrap.getInvokesSignAction());
    }

    private HandlesSignCreation creation(SignBootstrap bootstrap) {
        return new HandlesSignCreation(bootstrap.getStoresNewSign(), bootstrap.getRendersTemplateById(), bootstrap.getPlugin().getGlobalMessenger());
    }

    private HandlesSignDestruction destruction(SignBootstrap bootstrap) {
        return new HandlesSignDestruction(bootstrap.getRemovesSignAtLocation(), bootstrap.getPlugin().getGlobalMessenger());
    }

    private RedrawsSignsOnUpdates redraw(SignBootstrap bootstrap) {
        return new RedrawsSignsOnUpdates(bootstrap.getRedrawsArenaSigns(), bootstrap.getPlugin());
    }

    private void register(Listener listener, SignBootstrap bootstrap) {
        MobArena plugin = bootstrap.getPlugin();
        plugin.getServer().getPluginManager().registerEvents(listener, (Plugin)plugin);
    }

    public void unregister() {
        this.listeners.forEach(HandlerList::unregisterAll);
        this.listeners.clear();
    }
}

