/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.signs;

import com.garbagemule.MobArena.MobArena;
import com.garbagemule.MobArena.signs.InvokesSignAction;
import com.garbagemule.MobArena.signs.LoadsSignStore;
import com.garbagemule.MobArena.signs.LoadsTemplateStore;
import com.garbagemule.MobArena.signs.RedrawsArenaSigns;
import com.garbagemule.MobArena.signs.RemovesSignAtLocation;
import com.garbagemule.MobArena.signs.RendersTemplate;
import com.garbagemule.MobArena.signs.RendersTemplateById;
import com.garbagemule.MobArena.signs.SavesSignStore;
import com.garbagemule.MobArena.signs.SetsLines;
import com.garbagemule.MobArena.signs.SignStore;
import com.garbagemule.MobArena.signs.StoresNewSign;
import com.garbagemule.MobArena.signs.TemplateStore;

public class SignBootstrap {
    private final MobArena plugin;
    private final SignStore signStore;
    private final TemplateStore templateStore;
    private InvokesSignAction invokesSignAction;
    private RedrawsArenaSigns redrawsArenaSigns;
    private RemovesSignAtLocation removesSignAtLocation;
    private RendersTemplate rendersTemplate;
    private RendersTemplateById rendersTemplateById;
    private SetsLines setsLines;
    private StoresNewSign storesNewSign;
    private SavesSignStore savesSignStore;

    private SignBootstrap(MobArena plugin, SignStore signStore, TemplateStore templateStore) {
        this.plugin = plugin;
        this.signStore = signStore;
        this.templateStore = templateStore;
    }

    MobArena getPlugin() {
        return this.plugin;
    }

    SignStore getSignStore() {
        return this.signStore;
    }

    TemplateStore getTemplateStore() {
        return this.templateStore;
    }

    InvokesSignAction getInvokesSignAction() {
        if (this.invokesSignAction == null) {
            this.invokesSignAction = new InvokesSignAction(this.plugin.getArenaMaster(), this.plugin.getGlobalMessenger());
        }
        return this.invokesSignAction;
    }

    RedrawsArenaSigns getRedrawsArenaSigns() {
        if (this.redrawsArenaSigns == null) {
            this.redrawsArenaSigns = new RedrawsArenaSigns(this.getSignStore(), this.getTemplateStore(), this.getRendersTemplate(), this.getSetsLines());
        }
        return this.redrawsArenaSigns;
    }

    RemovesSignAtLocation getRemovesSignAtLocation() {
        if (this.removesSignAtLocation == null) {
            this.removesSignAtLocation = new RemovesSignAtLocation(this.getSignStore(), this.getSavesSignStore());
        }
        return this.removesSignAtLocation;
    }

    RendersTemplate getRendersTemplate() {
        if (this.rendersTemplate == null) {
            this.rendersTemplate = new RendersTemplate();
        }
        return this.rendersTemplate;
    }

    RendersTemplateById getRendersTemplateById() {
        if (this.rendersTemplateById == null) {
            this.rendersTemplateById = new RendersTemplateById(this.plugin.getArenaMaster(), this.getTemplateStore(), this.getRendersTemplate());
        }
        return this.rendersTemplateById;
    }

    SetsLines getSetsLines() {
        if (this.setsLines == null) {
            this.setsLines = new SetsLines();
        }
        return this.setsLines;
    }

    StoresNewSign getStoresNewSign() {
        if (this.storesNewSign == null) {
            this.storesNewSign = new StoresNewSign(this.plugin.getArenaMaster(), this.getTemplateStore(), this.getSignStore(), this.getSavesSignStore());
        }
        return this.storesNewSign;
    }

    SavesSignStore getSavesSignStore() {
        if (this.savesSignStore == null) {
            this.savesSignStore = new SavesSignStore(this.plugin);
        }
        return this.savesSignStore;
    }

    public static SignBootstrap create(MobArena plugin) {
        TemplateStore templateStore = new LoadsTemplateStore(plugin).read();
        SignStore signStore = new LoadsSignStore(plugin).load();
        SignBootstrap bootstrap = new SignBootstrap(plugin, signStore, templateStore);
        plugin.getArenaMaster().getArenas().forEach(bootstrap.getRedrawsArenaSigns()::redraw);
        return bootstrap;
    }
}

