/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.signs;

import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.framework.ArenaMaster;
import com.garbagemule.MobArena.signs.RendersTemplate;
import com.garbagemule.MobArena.signs.Template;
import com.garbagemule.MobArena.signs.TemplateStore;

class RendersTemplateById {
    private final ArenaMaster arenaMaster;
    private final TemplateStore templateStore;
    private final RendersTemplate rendersTemplate;

    RendersTemplateById(ArenaMaster arenaMaster, TemplateStore templateStore, RendersTemplate rendersTemplate) {
        this.arenaMaster = arenaMaster;
        this.templateStore = templateStore;
        this.rendersTemplate = rendersTemplate;
    }

    String[] render(String templateId, String arenaId) {
        Template template = this.templateStore.findById(templateId).orElseThrow(() -> new IllegalArgumentException("Template " + templateId + " not found"));
        Arena arena = this.arenaMaster.getArenaWithName(arenaId);
        if (arena == null) {
            throw new IllegalStateException("Arena " + arenaId + " not found");
        }
        return this.rendersTemplate.render(template, arena);
    }
}

